#include <string.h>
#include "internal.h"

const int NB_VARVAL=20;
static HTML_VARVAL *last[NB_VARVAL];
static int idalloc = 0;

/* #Specification: html mode / strategy / sub dialog
	The system (linuxconf) loosely remember the last 20 POST it received.
	Potentially a POST yields a sub-dialog. When receiving a POST,
	linuxconf record the variables and copy those to the application
	and return to it with the proper button (as per the POST). The
	application when receiving an ACCEPT button will return to a
	previous level (logical level of sub menu). Other button generally
	yield to sub-dialog. In this case, linuxconf will draw the sub-dialog
	and escape away to the main loop. The next time the user will post
	into this sub-dialog, linuxconf will rewalk the path and cross
	the previous post. At this point, the path will tell that this step
	was indeed a POST and linuxconf will reactivate the variable collected
	from the original POST and return the original button. This should
	recreate the situation yielding to the sub-dialog.

	This is why old variable-values from old POST have to be remembered.
*/
#
/*
	An HTML_VARVAL hold the content of a POST. It remember the
	path and the value of the different variables recover.

*/
PUBLIC HTML_VARVAL::HTML_VARVAL (const char *key)
{
	id = idalloc++;
	context.setfrom (key);
	delete last[NB_VARVAL-1];
	memmove (last+1,last,(NB_VARVAL-1)*sizeof(HTML_VARVAL*));
	last[0] = this;
}

/*
	Add a value pair (varible/value) to the list
*/
PUBLIC void HTML_VARVAL::add (const char *var, const char *val)
{
	vars.add (new SSTRING (var));
	vals.add (new SSTRING (val));
}


/*
	Return the number of variables in the table
*/
PUBLIC int HTML_VARVAL::getnb()
{
	return vars.getnb();
}

/*
	Return the value of a variable or "" if it is not there
*/
PUBLIC const char *HTML_VARVAL::getval(const char *var, int &exist)
{
	exist = 0;
	const char *ret = "";
	int n = vars.getnb();
	for (int i=0; i<n; i++){
		if (vars.getitem(i)->cmp(var)==0){
			ret = vals.getitem(i)->get();
			exist = 1;
			break;
		}
	}
	return ret;
}
/*
	Return the value of a variable
*/
PUBLIC const char *HTML_VARVAL::getval(int no)
{
	return vals.getitem(no)->get();
}
/*
	Return the name of a variable
*/
PUBLIC const char *HTML_VARVAL::getvar(int no)
{
	return vars.getitem(no)->get();
}
/*
	Return != 0 if a given variable do exist in this list.
*/
PUBLIC int HTML_VARVAL::exist(const char *var)
{
	int ret = 0;
	int n = vars.getnb();
	for (int i=0; i<n; i++){
		if (vars.getitem(i)->cmp(var)==0){
			ret = 1;
			break;
		}
	}
	return ret;
}
/*
	Return the context of the object.
*/
PUBLIC const char *HTML_VARVAL::getcontext()
{
	return context.get();
}

/*
	Return the context of the object.
*/
PUBLIC int HTML_VARVAL::getid()
{
	return id;
}


#if 0
/*
	Get the HTML_VARVAL for a given context
	Return NULL if not found.
*/
HTML_VARVAL *varval_get (const char *key)
{
	HTML_VARVAL *ret = NULL;
	for (int i=0; i<NB_VARVAL; i++){
		HTML_VARVAL *h = last[i];
		if (h != NULL && strcmp(key,h->getcontext())==0){
			ret = h;
			if (i != 0){
				memmove (last,last+1,i*sizeof(HTML_VARVAL*));
				last[0] = h;
			}
			break;
		}
	}
	return ret;
}
#endif

/*
	Get the HTML_VARVAL with a give ID
	Return NULL if not found.
*/
HTML_VARVAL *varval_get (int id)
{
	HTML_VARVAL *ret = NULL;
	for (int i=0; i<NB_VARVAL; i++){
		HTML_VARVAL *h = last[i];
		if (h != NULL && id == h->getid()){
			ret = h;
			for (int j=i; j>0; j--) last[j] = last[j-1];
			last[0] = h;
			break;
		}
	}
	return ret;
}

