/*****************************************************************************/
/* linleech - a program to selectively download usenet articles              */
/* Copyright (C) 1988  Curtiss Howard                                        */ 
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*****************************************************************************/

#include <slang.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "linleech_vars.h"

void Misc_Init (void)
{
	Misc.BytesReceived = 0;
	Misc.BytesSent = 0;
	Misc.Connected = FALSE;
	Misc.FilterOutput = FALSE;
	Misc.FilterSet = FALSE;
	Misc.ReqTrigger = FALSE;
	Misc.Resume = FALSE;
	
	strcpy (Misc.Filter, "");
	strcpy (Misc.SaveDir, "");
	
	Misc.SaveAll = FALSE;
	Misc.ShowHead = FALSE;

	ListVars.ListSize = 0;
	ListVars.ListCount = 0;
	ListVars.ListCreated = FALSE;

	re_syntax_options = RE_SYNTAX_POSIX_BASIC;
}

void main (int argc, char *argv[])
{
	FILE *Fptr;
	
	printf ("linleech> linleech 2.2.0 by Curtiss Howard, 1998.\n");

	if (argc < 2)
	{
		/* Very weird way to have to open stdin, but I have to for S-Lang. */
		   
		Fptr = fdopen ((int) stdin, "r");
		
		Misc_Init();

		SLang_Init();

		Begin = time (NULL);
	
		if (SLang_load_file ((char *) Fptr) == -1)
		{
			SLang_restart (1);

			SLang_Error = 0;
		}

		End = time (NULL);

		printf ("linleech> Finished execution.\n");
		printf ("linleech> Time elapsed: %ld min %ld sec.\n", (End - Begin)
			/ 60, (End - Begin) - (((End - Begin) / 60) * 60));
		printf ("linleech> Kilobytes received: %d.\n", Misc.BytesReceived / 
			1000);
		printf ("linleech> Kilobytes sent: %d.\n", Misc.BytesSent / 1000);
	}

	if (argc == 2)
	{
		Misc_Init();

		SLang_Init();

		printf ("linleech> Opening script %s... ", argv[1]);
	
		Fptr = fopen (argv[1], "r");

		if (!Fptr)
		{
			printf ("failure.\n");

			exit (0);
		}

		printf ("okay.\n");
		printf ("linleech> Running script %s...\n", argv[1]);

		Begin = time (NULL);
	
		if (SLang_load_file (argv[1]) == -1)
		{
			SLang_restart (1);

			SLang_Error = 0;
		}

		End = time (NULL);

		printf ("linleech> Finished running script %s.\n", argv[1]);
		printf ("linleech> Time elapsed: %ld min %ld sec.\n", (End - Begin)
			/ 60, (End - Begin) - (((End - Begin) / 60) * 60));
		printf ("linleech> Kilobytes received: %d.\n", Misc.BytesReceived / 
			1000);
		printf ("linleech> Kilobytes sent: %d.\n", Misc.BytesSent / 1000);
	}
}
