/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB/RBD/NJN
 *
 *	$Id: hf77.c,v 6.16 1999/08/05 06:54:59 jsquyres Exp $
 *
 *	Function:	- wrapper for FORTRAN program compilation
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <lam_config.h>
#include <args.h>
#include <boot.h>
#include <portable.h>

#ifndef DEFTF77
#define DEFTF77 LAM_F77
#endif

#ifndef FLIBPATH
#define FLIBPATH "-L"
#endif

/*
 * external functions
 */
extern int		cnfexec();

/*
 * local variables
 */
static char		ph[LAM_PATH_MAX];
static char		plib[LAM_PATH_MAX];
static char		extra[LAM_PATH_MAX];

int
main(argc, argv)

int			argc;
char			*argv[];

{
	int		ac;		/* f77 # args */
	int		status;		/* f77 return code */
	int		fl_libs;	/* add libs to command line */
	int		fl_show;	/* show what would be done */
	int             fl_building;    /* are we building LAM right now? */
	int		i;		/* favourite index */
	char		**av;		/* f77 arg vector */
	char		**sys;		/* system libraries arg vector */
	char		*phome;		/* installation dir */
	char		*tf77;		/* f77 tool */
#if LAM_WANT_ROMIO || LAM_WANT_MPI2CPP
	int             fd;
#endif

	phome = getenv("LAMHOME");
	if (phome == 0) phome = getenv("TROLLIUSHOME");
	if (phome == 0) phome = DEFP;

	if ((strlen(phome) + 32) >= LAM_PATH_MAX) {
	  char buffer[32];

	  snprintf(buffer, 32, "%d", LAM_PATH_MAX - 32);
	  show_help("compile", "phome-too-long", phome, buffer, "hcc", NULL);
	  exit(1);
	}
/*
 * Form include directory pathname.
 */
	strcpy(ph, "-I");
	strcat(ph, phome);
	strcat(ph, STRSDIR);
	strcat(ph, "include");
/*
 * Form library directory pathname.
 */
	strcpy(plib, FLIBPATH);
	strcat(plib, phome);
	strcat(plib, STRSDIR);
	strcat(plib, "lib");

	tf77 = getenv("LAMHF77");
	if (tf77 == 0) tf77 = getenv("TROLLIUSHF77");
	if (tf77 == 0) tf77 = DEFTF77;

	if (strcmp(tf77, "false") == 0 || strlen(tf77) == 0) {
	  show_help("hf77", "no-fortran-support", NULL);
	  exit(1);
	}

	if ((av = sfh_argv_break(tf77, ' ')) == 0) {
	  show_help(NULL, "lib-call-fail", "sfh_argv_break", NULL);
	  exit(errno);
	}

	ac = sfh_argv_count(av);

	fl_show = 0;
	fl_libs = 1;
	fl_building = 0;

	for (i = 1; i < argc; ++i) {
		if (strcmp(argv[i], "-showme") == 0) {
			fl_show = 1;
		} else if (strcmp(argv[i], "-c") == 0) {
			fl_libs = 0;
		} else if (strcmp(argv[i], "-building-lam") == 0) {
			fl_building = 0;
		}
	}

/*
 * If we're building LAM right now, #define LAM_BUILDING to be 1 so
 * that we don't try to include mpi++.h and mpio.h in mpi.h
 */
	if (fl_building) {
	  strcpy(extra, "-DLAM_BUILDING=1");
	  sfh_argv_add(&ac, &av, extra);
	}

	sfh_argv_add(&ac, &av, ph);
	if (fl_libs) {
		sfh_argv_add(&ac, &av, plib);
	}

	for (i = 1; i < argc; ++i) {
		if (strcmp(argv[i], "-showme")) {
			sfh_argv_add(&ac, &av, argv[i]);
		}
	}

	if (fl_libs) {
/*
 * Add system dependent link arguments.
 */
		if (strlen(HBIND) > 0) {
			if ((sys = sfh_argv_break(HBIND, ' ')) == 0) {
			  show_help(NULL, "lib-call-fail", "sfh_argv_break", 
				    NULL);
			  exit(errno);
			}

			for ( ; *sys; sys++) {
				sfh_argv_add(&ac, &av, *sys);
			}
		}
		if (fl_building == 0) {
/*
 * Do we want MPI 2 C++ bindings support?
 *
 * Tricky -- we have to test for presence of libmpi++.a first, "just
 * in case".  This is really only here for the obscure case where a
 * fortran module calls some other module that calls something in the
 * C++ bindings (because I don't know of any way to call C++ directly
 * from Fortran!).  
 */
#if LAM_WANT_MPI2CPP
		  strcpy(extra, plib + 2);
		  strcat(extra, "/libmpi++.a");
		  fd = open(extra, O_RDONLY);
		  if (fd >= 0) {
		    sfh_argv_add(&ac, &av, "-lmpi++");
		    close(fd);
		  }
#endif
/*
 * Do we want ROMIO support?
 * Tricky -- we have to test for presence of libmpio.a first, "just in 
 * case".
 */
#if LAM_WANT_ROMIO
		  strcpy(extra, plib + 2);
		  strcat(extra, "/libmpio.a");
		  fd = open(extra, O_RDONLY);
		  if (fd >= 0) {
		    sfh_argv_add(&ac, &av, "-lmpio");
#if HAVE_LIBAIO
		    sfh_argv_add(&ac, &av, "-laio");
#endif
		    close(fd);
		  }
#endif
		}
/*
 * Add standard LAM libraries.
 */
		sfh_argv_add(&ac, &av, "-lmpi");
#if LAM_WANT_IMPI
		/* Argh.  Don't ask. */
		sfh_argv_add(&ac, &av, "-limpi");
		sfh_argv_add(&ac, &av, "-lmpi");
		sfh_argv_add(&ac, &av, "-limpi");
#endif
		sfh_argv_add(&ac, &av, "-ltstdio");
		sfh_argv_add(&ac, &av, "-ltrillium");
		sfh_argv_add(&ac, &av, "-largs");
		sfh_argv_add(&ac, &av, "-lt");
/*
 * Add system dependent libraries.
 */
		if (strlen(SYSLIBS) > 0) {
			if ((sys = sfh_argv_break(SYSLIBS, ' ')) == 0) {
			  show_help(NULL, "lib-call-fail", "sfh_argv_break", 
				    NULL);
			  exit(errno);
			}

			for ( ; *sys; sys++) {
				sfh_argv_add(&ac, &av, *sys);
			}
		}
	}

	if (fl_show) {
		for (i = 0; i < ac; i++) {
			printf("%s ", av[i]);
		}
		printf("\n");
	} else {
		status = cnfexec(av);

		if (status) {
		  if (errno != 0)
		    perror("hf77");
		  exit(status);
		}
	}

	return(0);
}
