/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *      Copyright 1996 The Ohio State University
 *      GDB/RBD
 *
 *	$Id: TRIL.c,v 6.3 1999/07/28 00:32:07 jsquyres Exp $
 *
 *	Function:	- f2c F77 interface for libtrillium functions
 */

#include <stdlib.h>

#include <lam_config.h>

#include <portable.h>
#include <preq.h>
#include <terror.h>

/*
 * external functions
 */
extern char		*f2cstring();

/*
 * F77/C interface
 */
#if LAM_FORTRANNOUNDERSCORE
#define rpwt_		rpwt
#define rpldgo_		rpldgo
#endif

/*
 * simple wrappers
 */
void rpwt_(n, p, s, ie) int4 *n, *p, *s, *ie;
		{ *ie = rpwait(n, p, s) ? errno : 0; }

/*
 * thicker wrappers
 */
void
rpldgo_(srcnode, destnode, filename, flags, pid, idx, ierror, lstr)

int4			*srcnode;
int4			*destnode;
char			*filename;
int4			*flags;
int4			*pid;
int4			*idx;
int4			*ierror;
unsigned int		lstr;

{
	char		*cstr;
	int		r;

	if ((cstr = f2cstring(filename, lstr)) == 0) {
		*ierror = errno;
		return;
	}

	r = rploadgo(*srcnode, *destnode, cstr, *flags, (char **) 0, pid, idx);
	*ierror = r ? errno : 0;

	free(cstr);
}
