/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: lamcid.c,v 6.5 1999/07/28 00:32:01 jsquyres Exp $
 *
 *	Function:	- manage context identifiers
 *			- trivial version
 */

#include <typical.h>
#include <mpi.h>
#include <mpisys.h>
#include <lam_config.h>

/*
 * static variables
 */
static int		topcid = 0;		/* top unused context ID */

/*
 *	lam_getcid
 *
 *	Function:	- get next available context ID
 *	Returns:	- context ID or LAMERROR
 */
int
lam_getcid()

{
	return( ((topcid < 0) || (topcid > MPI_MAX_CID)) ? LAMERROR : topcid);
}

/*
 *	lam_setcid
 *
 *	Function:	- set highest used context ID
 *	Accepts:	- context ID
 */
void
lam_setcid(cid)

int			cid;

{
#if LAM_WANT_IMPI
        topcid = cid + 2;
#else
        topcid = cid + 1;
#endif
}

/*
 *	lam_rmcid
 *
 *	Function:	- deallocate (remove) a context ID
 *	Accepts:	- context ID
 */
void
lam_rmcid(cid)

int			cid;

{
}

/*
 *	lam_nukecids
 *
 *	Function:	- deallocate all context IDs (cleanup)
 */
void
lam_nukecids()

{
	topcid = 0;
}
