/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: spawnmult_f.c,v 6.6 1999/09/02 01:34:29 prijks Exp $
 *
 *	Function:	- MPI_Comm_spawn_multiple F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <args.h>
#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>
#include <typical.h>

/*
 * private functions
 */
static int		f2c_argvs();


void
mpi_comm_spawn_multiple_(n, cmd, av, mps, infs, root, comm, icomm,
			ec, ierr, nc, na)

char			*cmd, *av;
int			*n, *mps, *infs, *root, *comm, *icomm, *ec, *ierr;
int			nc, na;

{
	MPI_Comm	intercomm;
	MPI_Info	*infos;
	char		***argvs = 0;
	char		**commands;
	int		*errs;
	int		i;
/*
 * check arguments
 */
	if (*n <= 0) {
		lam_setfunc(BLKMPICOMMSPAWNMULT);
		*ierr = lam_errfunc(GETHDL(*comm), BLKMPICOMMSPAWNMULT,
					lam_mkerr(MPI_ERR_ARG, 0));
		return;
	}
/*
 * Create info array.
 */
	if ((infos = (MPI_Info *) malloc(*n * sizeof(MPI_Info *))) == 0) {
		lam_setfunc(BLKMPICOMMSPAWNMULT);
		*ierr = lam_errfunc(GETHDL(*comm), BLKMPICOMMSPAWNMULT,
					lam_mkerr(MPI_ERR_SPAWN, errno));
		return;
	}

	for (i = 0; i < *n; i++) {
		infos[i] = GETHDL(infs[i]);
	}
/*
 * Check for special argument values.
 */
	if ((void *) ec == lam_F_errorcodes_ignore) {
		errs = 0;
	} else {
		errs = ec;
	}

	if ((void *) av == lam_F_argvsnull) {
		argvs = 0;
	} else {
/*
 * Convert F77 argument arrays to C argument vectors.
 */
		if (f2c_argvs(*n, av, na, &argvs)) {
			free((char *) infos);
			lam_setfunc(BLKMPICOMMSPAWNMULT);
			*ierr = lam_errfunc(GETHDL(*comm), BLKMPICOMMSPAWNMULT,
					lam_mkerr(MPI_ERR_SPAWN, errno));
			return;
		}
	}
/*
 * Convert F77 command strings to C array of commands.
 */
	if (lam_F2C_argv(cmd, nc, &commands)) {
		free((char *) infos);
		for (i = 0; i < *n; i++) {
			argvfree(argvs[i]);
		}
		lam_setfunc(BLKMPICOMMSPAWNMULT);
		*ierr = lam_errfunc(GETHDL(*comm), BLKMPICOMMSPAWNMULT,
					lam_mkerr(MPI_ERR_SPAWN, errno));
		return;
	}

	*ierr = MPI_Comm_spawn_multiple(*n, commands, argvs, mps, infos,
				*root, GETHDL(*comm), &intercomm, errs);

	if (lam_F_make_hdl(icomm, ierr, intercomm, BLKMPICOMMSPAWNMULT)) {
		intercomm->c_f77handle = *icomm;
	}

	for (i = 0; i < *n; i++) {
		argvfree(argvs[i]);
	}
	argvfree(commands);
	free((char *) infos);
}

/*
 *	f2c_argvs
 *
 *	Function:	- creates array of C argument vector from an
 *			  F77 2-d array of strings
 *	Accepts:	- first dimension of 2-d array
 *			- F77 2-d array of strings
 *			- length of strings
 *			- array of C argument vectors (out)
 *	Returns:	- 0 or LAMERROR
 */
static int
f2c_argvs(dim, array, len, argvs)

int			dim;
char			*array;
int			len;
char			****argvs;

{
	int		argc;			/* argument vector count */
	char		***argvarr;		/* array of argument vectors */
	char		*cstr;			/* C string */
	char		*p;
	int		i, j;

	if ((argvarr = (char ***) malloc(dim * sizeof(char **))) == 0) {
		return(LAMERROR);
	}

	for (i = 0; i < dim; i++) {

		argc = 0;
		argvarr[i] = 0;
		p = array + len * i;

		while (1) {
			cstr = lam_F2C_string(p, len);

			if (cstr == 0) {
				for (j = 0; j <= i; j++) {
					argvfree(argvarr[j]);
				}
				return(LAMERROR);
			}

			if (*cstr == 0) break;

			if (argvadd(&argc, &argvarr[i], cstr)) {
				for (j = 0; j <= i; j++) {
					argvfree(argvarr[j]);
				}
				return(LAMERROR);
			}

			p += len * dim;
		}
	}

	*argvs = argvarr;
	return(0);
}
