/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: dupfn.c,v 6.3 1999/05/25 22:07:51 kmeyer1 Exp $
 *
 *	Function:	- pre-defined simple attribute copy functions
 *	Accepts:	- communicator/datatytpe/window
 *			- key value
 *			- extra state info
 *			- in attribute value
 *			- out attribute value (out)
 *			- flag (out)
 *	Returns:	- MPI_SUCCESS
 */

#include <mpi.h>

int
MPI_DUP_FN(comm, key, extra, attrin, attrout, flag)

MPI_Comm		comm;
int			key;
void			*extra;
void			*attrin;
void			*attrout;
int			*flag;

{
	*flag = 1;
	*((void **) attrout) = attrin;

	return(MPI_SUCCESS);
}

int
MPI_COMM_DUP_FN(comm, key, extra, attrin, attrout, flag)

MPI_Comm		comm;
int			key;
void			*extra;
void			*attrin;
void			*attrout;
int			*flag;

{
	*flag = 1;
	*((void **) attrout) = attrin;

	return(MPI_SUCCESS);
}

int
MPI_TYPE_DUP_FN(dtype, key, extra, attrin, attrout, flag)

MPI_Datatype		dtype;
int			key;
void			*extra;
void			*attrin;
void			*attrout;
int			*flag;

{
	*flag = 1;
	*((void **) attrout) = attrin;

	return(MPI_SUCCESS);
}

int
MPI_WIN_DUP_FN(win, key, extra, attrin, attrout, flag)

MPI_Win			win;
int			key;
void			*extra;
void			*attrin;
void			*attrout;
int			*flag;

{
	*flag = 1;
	*((void **) attrout) = attrin;

	return(MPI_SUCCESS);
}
