/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	$Id: pdi.h,v 6.3 1999/04/01 21:38:53 kmeyer1 Exp $
 * 
 *	Function:	- process identifier parsing
 */

#ifndef _PDI_H
#define _PDI_H

#include <lam_config.h>
#include <all_list.h>
#include <portable.h>
/*
 * global functions
 */
LIST *			pdi_parse();

/*
 * node identifier list entry
 */
struct pdi {
	int4		pdi_node;	/* ID itself */
	int4		pdi_flags;	/* descriptive flags */
	int4		pdi_count;	/* # IDs actually represented */
	int4		pdi_index;	/* position in list (legacy) */
};

#ifdef __cplusplus
extern "C" {
#endif

extern LIST *	pdi_parse __ARGS((int argc, char ** argv, char *** othersv));

#ifdef __cplusplus
}
#endif

#endif	/* _PDI_H */
