//LabPlot : GraphIMAGE.cc

#include <stdlib.h>
#include <iostream>
#include <qimage.h>
#include <qbuffer.h>
#include <kdebug.h>
#include "GraphIMAGE.h"

using namespace std;

GraphIMAGE::GraphIMAGE(QString n, QString l, LRange r[3], LSource src, PType t, Style *st,
		Symbol *sy, QPixmap pm,int dimx, int dimy, bool s)
	: Graph(n,l,src,t,st,sy,dimx*dimy,s)
{
	if(r) {
		range[0].setMin(r[0].rMin());
		range[0].setMax(r[0].rMax());
		range[1].setMin(r[1].rMin());
		range[1].setMax(r[1].rMax());
		range[2].setMin(r[2].rMin());
		range[2].setMax(r[2].rMax());
	}

	pixmap = pm;
}

void GraphIMAGE::saveXML(QDomDocument doc, QDomElement graphtag) {
	QDomElement tag = doc.createElement( "Range" );
	tag.setAttribute("xmin",QString::number(range[0].rMin()));
	tag.setAttribute("xmax",QString::number(range[0].rMax()));
	tag.setAttribute("ymin",QString::number(range[1].rMin()));
	tag.setAttribute("ymax",QString::number(range[1].rMax()));
	tag.setAttribute("zmin",QString::number(range[2].rMin()));
	tag.setAttribute("zmax",QString::number(range[2].rMax()));
    	graphtag.appendChild( tag );

	// dump image
	QCString pixmapstr;
	QBuffer buffer(pixmapstr);
	buffer.open(IO_ReadWrite);
#if QT_VERSION > 0x030102
	pixmap.save(&buffer,"XPM");
#endif
	buffer.close();
	tag = doc.createElement( "Image" );
	tag.setAttribute("length",QString::number(pixmapstr.length()));
   	graphtag.appendChild( tag );
  	QDomText t = doc.createTextNode( pixmapstr );
    	tag.appendChild( t );
}

void GraphIMAGE::save(QTextStream *t) {
	saveGraph(t);

	*t<<range[0].rMin()<<' '<<range[0].rMax()<<endl;
	*t<<range[1].rMin()<<' '<<range[1].rMax()<<endl;
	*t<<range[2].rMin()<<' '<<range[2].rMax()<<endl;
	*t<<type<<' ';
	style->save(t);
	symbol->save(t);

	// save pixmap
#if QT_VERSION > 0x030102
	pixmap.save(t->device(),"BMP");
	*t<<endl;
#endif
}

GraphIMAGE *GraphIMAGE::Clone() {
	GraphIMAGE *newg = new GraphIMAGE(*this);
	Label *l = new Label();
	*l = *(label);
	newg->setLabel(l);	// set label

	LRange nrange[3];
	nrange[0] = range[0];
	nrange[1] = range[1];
	nrange[2] = range[2];
	newg->setRange(nrange);

	return newg;
}

void GraphIMAGE::open(QTextStream *t, int version, QProgressDialog *) {
	openGraph(t,version);

	double zmin, zmax;
	*t>>zmin>>zmax;
	range[0].setMin(zmin); range[0].setMax(zmax);
	*t>>zmin>>zmax;
	range[1].setMin(zmin); range[1].setMax(zmax);
	*t>>zmin>>zmax;
	range[2].setMin(zmin); range[2].setMax(zmax);

	type = (PType) style->open(t,version);
	symbol->open(t,version);

	// read pixmap
#if QT_VERSION > 0x030102
	int len = (int) (3*range[0].rMax()*range[1].rMax())+55;
	kdDebug()<<"reading pixmap of size "<<len<<endl;
	char *buf = new char[len];
	t->readRawBytes(buf,len);
	pixmap.loadFromData((const uchar *)buf,len);
#endif
}

void GraphIMAGE::openXML(QDomNode node) {
	while(!node.isNull()) {
		QDomElement e = node.toElement();
//		kdDebug()<<"GRAPH TAG = "<<e.tagName()<<endl;
//		kdDebug()<<"GRAPH TEXT = "<<e.text()<<endl;

		openGraphXML(e);

		if(e.tagName() == "Range") {
			range[0].setRange(e.attribute("xmin").toDouble(),e.attribute("xmax").toDouble());
			range[1].setRange(e.attribute("ymin").toDouble(),e.attribute("ymax").toDouble());
			range[2].setRange(e.attribute("zmin").toDouble(),e.attribute("zmax").toDouble());
		}
		else if(e.tagName() == "Image") {
			int len = e.attribute("length").toInt();
			const char *buf = new char[len];
			buf = e.text().latin1();
			pixmap.loadFromData((const uchar *)buf,len);
		}

		node = node.nextSibling();
	}
}

QStringList GraphIMAGE::Info(){
	QStringList s;
	QString t=i18n("Image");

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << label->simpleTitle() << t << sh;
	s << QString::number(range[0].rMin())+ " .. " + QString::number(range[0].rMax());
	s << QString::number(range[1].rMin())+ " .. " + QString::number(range[1].rMax());
	s << QString::number(range[2].rMin())+ " .. " + QString::number(range[2].rMax());

	return s;
}
