(* Copyright (C) 2000, Luca Padovani <luca.padovani@cs.unibo.it>.
 *
 * This file is part of lablgtkmathview, the Ocaml binding
 * for the GtkMathView widget.
 * 
 * lablgtkmathview is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * lablgtkmathview is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with lablgtkmathview; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For details, send a mail to the author.
 *)

open Gtk
open Gtk_mathview
open Tags
open GtkBase
open Gpointer

external gdome_element_of_boxed_option :
 Gpointer.boxed option -> TElement.t =
  "ml_gtk_math_view_gdome_element_of_boxed_option"

external gdome_element_option_of_boxed_option :
 Gpointer.boxed option -> TElement.t option =
  "ml_gtk_math_view_gdome_element_option_of_boxed_option"

module MathView = struct
  exception NoSelection

  let cast w : math_view obj = Object.try_cast w "GtkMathView"
  external create : Gtk.adjustment optobj -> Gtk.adjustment optobj -> 
   math_view obj = "ml_gtk_math_view_new"
  let create ~adjustmenth ~adjustmentv () =
   create (optboxed adjustmenth) (optboxed adjustmentv)
  external load : [>`math_view] obj -> filename:string -> bool =
   "ml_gtk_math_view_load"
  external load_tree : [>`math_view] obj -> dom:[> `Document] GdomeT.t -> bool =
   "ml_gtk_math_view_load_tree"
  external unload : [>`math_view] obj -> unit =
   "ml_gtk_math_view_unload"
  external get_selection : [>`math_view] obj -> TElement.t option =
   "ml_gtk_math_view_get_selection"
  external set_selection :
   [>`math_view] obj -> [> `Element] GdomeT.t option -> unit=
   "ml_gtk_math_view_set_selection"
  external get_width : [>`math_view] obj -> int =
   "ml_gtk_math_view_get_width"
  external get_height : [>`math_view] obj -> int =
   "ml_gtk_math_view_get_height"
  external get_top : [>`math_view] obj -> (int * int) =
   "ml_gtk_math_view_get_top"
  external set_top : [>`math_view] obj -> int -> int -> unit =
   "ml_gtk_math_view_set_top"
  external set_adjustments : [>`math_view] obj -> Gtk.adjustment obj -> Gtk.adjustment obj -> unit =
   "ml_gtk_math_view_set_adjustments"
  external get_hadjustment : [>`math_view] obj -> Gtk.adjustment obj =
   "ml_gtk_math_view_get_hadjustment"
  external get_vadjustment : [>`math_view] obj -> Gtk.adjustment obj =
   "ml_gtk_math_view_get_vadjustment"
  external get_buffer : [>`math_view] obj -> Gdk.pixmap =
   "ml_gtk_math_view_get_buffer"
  external get_frame : [>`math_view] obj -> Gtk.frame obj =
   "ml_gtk_math_view_get_frame"
  external set_font_size : [>`math_view] obj -> int -> unit =
   "ml_gtk_math_view_set_font_size"
  external get_font_size : [>`math_view] obj -> int =
   "ml_gtk_math_view_get_font_size"
  external set_anti_aliasing : [>`math_view] obj -> bool -> unit =
   "ml_gtk_math_view_set_anti_aliasing"
  external get_anti_aliasing : [>`math_view] obj -> bool =
   "ml_gtk_math_view_get_anti_aliasing"
  external set_kerning : [>`math_view] obj -> bool -> unit =
   "ml_gtk_math_view_set_kerning"
  external get_kerning : [>`math_view] obj -> bool =
   "ml_gtk_math_view_get_kerning"
  external set_transparency : [>`math_view] obj -> bool -> unit =
   "ml_gtk_math_view_set_transparency"
  external get_transparency : [>`math_view] obj -> bool =
   "ml_gtk_math_view_get_transparency"
  external set_log_verbosity : [>`math_view] obj -> int -> unit =
   "ml_gtk_math_view_set_log_verbosity"
  external get_log_verbosity : [>`math_view] obj -> int =
   "ml_gtk_math_view_get_log_verbosity"
  external export_to_postscript :
   [>`math_view] obj -> width:int -> height:int -> x_margin:int -> y_margin:int -> disable_colors:bool -> filename:string -> bool =
   "ml_gtk_math_view_export_to_postscript_bytecode" "ml_gtk_math_view_export_to_postscript_native"
  external get_font_manager_type : [>`math_view] obj ->
   [`font_manager_gtk | `font_manager_t1] =
   "ml_gtk_math_view_get_font_manager_type"
  external set_font_manager_type : [>`math_view] obj ->
    fm_type:[`font_manager_gtk | `font_manager_t1] -> unit =
   "ml_gtk_math_view_set_font_manager_type"
  external get_element : [>`math_view] obj -> TElement.t option =
   "ml_gtk_math_view_get_element"
  external action_get_selected : [>`math_view] obj -> int =
   "ml_gtk_math_view_action_get_selected"
  external action_set_selected : [>`math_view] obj -> int -> unit =
   "ml_gtk_math_view_action_set_selected"
  external get_action : [>`math_view] obj -> TElement.t option =
   "ml_gtk_math_view_get_action"
  external action_toggle : [>`math_view] obj -> unit =
   "ml_gtk_math_view_action_toggle"
  
  module Signals = struct
    open GtkSignal

    let clicked : ([>`math_view],_) t =
     let marshal_clicked f _ =
      function
         [GtkArgv.POINTER element] -> f (gdome_element_of_boxed_option element)
       | _ -> invalid_arg "GtkMathView.MathView.Signals.marshal_clicked"
     in
      { name = "clicked"; marshaller = marshal_clicked }

    let selection_changed : ([>`math_view],_) t =
     let marshal_selection_changed f _ =
      function
         [GtkArgv.POINTER element] -> f (gdome_element_option_of_boxed_option element)
       | _ -> invalid_arg "GtkMathView.MathView.Signals.marshal_selection_changed"
     in
      { name = "selection_changed"; marshaller = marshal_selection_changed }

    let element_changed : ([>`math_view],_) t =
     let marshal_element_changed f _ =
      function
         [GtkArgv.POINTER element] -> f (gdome_element_option_of_boxed_option element)
       | _ -> invalid_arg "GtkMathView.MathView.Signals.marshal_element_changed"
     in
      { name = "element_changed"; marshaller = marshal_element_changed }
  end
end
