// =============================================================================
//
//   Copyright (C) 1999-2000 Szymon Stefanek
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviStylePure"

#include <qmenudata.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qwidget.h>

#include "kvi_style_pure.h"

extern QPixmap *arrow_pix;
extern QPixmap *check_pix;

extern QPixmap *pure_marble_pix;

KviPureStyle::KviPureStyle()
	: QPlatinumStyle()
{
	// Nothing here
}

KviPureStyle::~KviPureStyle()
{
	// Nothing here
}

void KviPureStyle::polish(QPalette &pal)
{
	QColorGroup normal(
		Qt::black,             // Foreground
		QColor(255, 185, 156), // Button
		Qt::white,             // Light
		QColor(5, 4, 0),       // Dark
		QColor(255, 116, 111), // Mid
		Qt::black,             // Text
		Qt::gray,              // Bright text
		Qt::lightGray,         // Base
		QColor(255, 185, 156)  // Background
	);
	pal.setInactive(normal);
	pal.setActive(normal);
	pal.setDisabled(normal);
}

void KviPureStyle::polish(QWidget *w)
{
	if( w->inherits("KviToolBar") || w->inherits("KviMenuBar") || w->inherits("KviStatusBar") ) {
		w->setBackgroundPixmap(*pure_marble_pix);
		return;
	}
}

void KviPureStyle::unPolish(QWidget *w)
{
	if( w->inherits("KviToolBar") || w->inherits("KviMenuBar") || w->inherits("KviStatusBar") ) {
		w->setBackgroundPixmap(QPixmap());
		w->setBackgroundMode(PaletteButton);
		return;
	}
}

void KviPureStyle::drawPopupMenuItem(
	QPainter *p, bool checkable, int maxpmw, int tab, QMenuItem *mi,
	const QPalette &pal, bool act, bool enabled, int x, int y, int w, int h
)
{
	if( mi->isSeparator() ) { // Draw separator
		p->setPen(Qt::black);
		p->drawLine(x, y, x + w, y);
		p->setPen(Qt::white);
		p->drawLine(x, y + 1, x + w, y + 1);
		return;
	}

	if( act && enabled ) p->setRasterOp(Qt::NotCopyROP);
	p->drawTiledPixmap(x, y, w, h, *pure_marble_pix, x % pure_marble_pix->width(), y % pure_marble_pix->height());

	if( maxpmw < h && maxpmw )
		maxpmw = h;

	if( mi->isChecked() ) {
		int dist = (h - 12) >> 1;
		QPoint pnt(x + w - (12 + dist), y + dist);
		p->drawPixmap(pnt, *check_pix);
	} else if( mi->popup() ) {
		int dist = (h - 12) >> 1;
		QPoint pnt(x + w - (12 + dist), y + dist);
		p->drawPixmap(pnt, *arrow_pix);
	}

	if( act && enabled ) p->setRasterOp(Qt::CopyROP);

	if( mi->iconSet() ) {
		QIconSet::Mode mode = (!enabled) ? QIconSet::Disabled : QIconSet::Normal;
		if( act && enabled ) mode = QIconSet::Active;
		QPixmap pixmap = mi->iconSet()->pixmap(QIconSet::Small, mode);
		int pixw = pixmap.width();
		int pixh = pixmap.height();
		QRect cr(x, y, maxpmw, h);
		QRect pmr(0, 0, pixw, pixh);
		pmr.moveCenter(cr.center());
		p->drawPixmap(pmr.topLeft(), pixmap);
	}

	QString s = mi->text();

	if( !s.isNull() ) {
		QColor darkRed(90, 0, 0);
		p->setPen(enabled ? (act ? Qt::red : white) : Qt::lightGray);
		if( !s.isNull() )
			p->drawText(x + maxpmw + 5, y + 1, w - maxpmw - 12, h - 2, AlignVCenter | ShowPrefix | DontClip | SingleLine, s);
		p->setPen(enabled ? (act ? Qt::black : darkRed) : Qt::darkGray);
		if( !s.isNull() )
			p->drawText(x + maxpmw + 4, y, w - maxpmw - 12, h - 2, AlignVCenter | ShowPrefix | DontClip | SingleLine, s);
	} else {
		QPixmap *pixm = mi->pixmap();
		if( pixm ) {
			if( !pixm->isNull() ) {
				QPoint pnt(x + ((w - (maxpmw + pixm->width())) >> 1), y + ((h - pixm->height()) >> 1));
				p->drawPixmap(pnt, *pixm);
			}
		}
	}
}

#include "m_kvi_style_pure.moc"
