#ifndef _KVI_SCRIPT_WIZARD_H_INCLUDED_
#define _KVI_SCRIPT_WIZARD_H_INCLUDED_

// =============================================================================
//
//      --- kvi_script_wizard.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_string.h"
#include "kvi_wizard.h"

class QCheckBox;
class QTextEdit;

class KviLineEdit;
class KviListBox;
class KviPushButton;
class KviScriptEditor;
class KviWindow;

typedef struct KviSaveScriptStructTag
{
	KviWindow *pWnd;
	KviStr     szName;            // Script long name
	KviStr     szVersion;         // Script version
	KviStr     szSubdir;          // Subdirectory
	KviStr     szAuthor;          // Author name
	KviStr     szEMail;           // Author email
	KviStr     szDescription;     // Description
	bool       bSaveColors;
	bool       bSaveFonts;
	bool       bSaveBackgrounds;
	bool       bSaveTextColors;

	bool       bSaveMessages;
	bool       bSaveOutputRedirection;
	bool       bSaveCTCPOptions;
	bool       bSaveIrcEngineOptions;

	bool       bSaveAliases;
	bool       bSaveEvents;
	bool       bSaveRawEvents;
	bool       bSavePopups;
	bool       bSaveToolbar;

	KviStr     szEpilogue;

	bool       bCreateTarball;

	QPtrList<KviStr> *pExtraFilesList;
} KviSaveScriptStruct;

class KviScriptWizard : public KviWizard
{
	Q_OBJECT
public:
	KviScriptWizard();
	~KviScriptWizard();
protected:
	QWidget         *m_pPage1;
	KviLineEdit     *m_pNameEdit;
	KviLineEdit     *m_pVersionEdit;
	KviLineEdit     *m_pSubdirEdit;

	QWidget         *m_pPage2;
	KviLineEdit     *m_pAuthorEdit;
	KviLineEdit     *m_pEMailEdit;
	QTextEdit       *m_pDescriptionEdit;

	QWidget         *m_pPage3;
	QCheckBox       *m_pSaveColorsCheck;
	QCheckBox       *m_pSaveFontsCheck;
	QCheckBox       *m_pSaveBackgroundsCheck;
	QCheckBox       *m_pSaveTextColorsCheck;

	QWidget         *m_pPage4;
	QCheckBox       *m_pSaveAliasesCheck;
	QCheckBox       *m_pSaveEventsCheck;
	QCheckBox       *m_pSavePopupsCheck;
	QCheckBox       *m_pSaveToolbarCheck;
	QCheckBox       *m_pSaveRawEventsCheck;

	QWidget         *m_pPage5;
	QCheckBox       *m_pSaveMessagesCheck;
	QCheckBox       *m_pSaveOutputRedirectionCheck;
	QCheckBox       *m_pSaveCTCPOptionsCheck;
	QCheckBox       *m_pSaveIrcEngineOptionsCheck;

	QWidget         *m_pPage6;
	KviListBox      *m_pExtraFilesBox;
	KviPushButton   *m_pRemoveExtra;

	QWidget         *m_pPage7;
	KviScriptEditor *m_pEpilogue;

	QWidget         *m_pPage8;
	QCheckBox       *m_pCreateTarball;

public:
	void fillSaveScriptStruct(KviSaveScriptStruct *);
protected:
	virtual void closeEvent(QCloseEvent *);
	virtual void done(int);
protected slots:
	void page1TextChanged(const QString &);
	void addExtraFile();
	void removeSelectedExtraFiles();
signals:
	void finished(bool bAccepted);
};

#endif // _KVI_SCRIPT_WIZARD_H_INCLUDED_
