#ifndef _KVI_SCRIPT_WIDGET_H_INCLUDED_
#define _KVI_SCRIPT_WIDGET_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_script_object.h"

class KviScriptWidget : public KviScriptObject
{
	friend class KviScriptButton;
	friend class KviScriptCheckBox;
	friend class KviScriptComboBox;
	friend class KviScriptLabel;
	friend class KviScriptLayout;
	friend class KviScriptLineEdit;
	friend class KviScriptPopupMenu;
	friend class KviScriptSpinBox;
	friend class KviScriptSplitter;
	friend class KviScriptTabWidget;
	friend class KviScriptTextEdit;
	friend class KviScriptToolBar;
	friend class KviScriptToolButton;
	friend class KviScriptTreeView;
	friend class KviScriptTreeViewItem;

	Q_OBJECT
public:
	KviScriptWidget(KviScriptObjectController *, KviScriptObject *, const char *name, KviScriptObjectClassDefinition *);
	~KviScriptWidget();

	virtual bool init(QPtrList<KviStr> *params);
	static void initializeClassDefinition(KviScriptObjectClassDefinition *);
	int               builtinFunction_SHOW(QPtrList<KviStr> *params, KviStr &buffer);
	int               builtinFunction_HIDE(QPtrList<KviStr> *params, KviStr &buffer);
	int                  builtinFunction_X(QPtrList<KviStr> *params, KviStr &buffer);
	int                  builtinFunction_Y(QPtrList<KviStr> *params, KviStr &buffer);
	int              builtinFunction_WIDTH(QPtrList<KviStr> *params, KviStr &buffer);
	int             builtinFunction_HEIGHT(QPtrList<KviStr> *params, KviStr &buffer);
	int    builtinFunction_SETMINIMUMWIDTH(QPtrList<KviStr> *params, KviStr &buffer);
	int   builtinFunction_SETMINIMUMHEIGHT(QPtrList<KviStr> *params, KviStr &buffer);
	int         builtinFunction_ISTOPLEVEL(QPtrList<KviStr> *params, KviStr &buffer);
	int          builtinFunction_ISVISIBLE(QPtrList<KviStr> *params, KviStr &buffer);
	int        builtinFunction_SETGEOMETRY(QPtrList<KviStr> *params, KviStr &buffer);
	int          builtinFunction_ISENABLED(QPtrList<KviStr> *params, KviStr &buffer);
	int         builtinFunction_SETENABLED(QPtrList<KviStr> *params, KviStr &buffer);
	int       builtinFunction_PARENTWIDGET(QPtrList<KviStr> *params, KviStr &buffer);
	int            builtinFunction_CAPTION(QPtrList<KviStr> *params, KviStr &buffer);
	int         builtinFunction_SETCAPTION(QPtrList<KviStr> *params, KviStr &buffer);
	int              builtinFunction_RAISE(QPtrList<KviStr> *params, KviStr &buffer);
	int              builtinFunction_LOWER(QPtrList<KviStr> *params, KviStr &buffer);
	int           builtinFunction_SETFOCUS(QPtrList<KviStr> *params, KviStr &buffer);
	int           builtinFunction_HASFOCUS(QPtrList<KviStr> *params, KviStr &buffer);
	int builtinFunction_SETBACKGROUNDCOLOR(QPtrList<KviStr> *params, KviStr &buffer);
	int    builtinFunction_BACKGROUNDCOLOR(QPtrList<KviStr> *params, KviStr &buffer);
	int      builtinFunction_SETQTPROPERTY(QPtrList<KviStr> *params, KviStr &buffer);
	int         builtinFunction_QTPROPERTY(QPtrList<KviStr> *params, KviStr &buffer);
	int   builtinFunction_LISTQTPROPERTIES(QPtrList<KviStr> *params, KviStr &buffer);
protected slots:
	void widgetDestroyed();
protected:
	QWidget   *m_pWidget;
	bool       m_bAutoDestroyControlledWidget;

	bool eventFilter(QObject *, QEvent *);
	void recursiveShow();
};

#endif // _KVI_SCRIPT_WIDGET_H_INCLUDED_
