#ifndef _KVI_USERLISTBOX_H_INCLUDED_
#define _KVI_USERLISTBOX_H_INCLUDED_

// =============================================================================
//
//      --- kvi_userlistbox.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>
#include <qwidget.h>

class QPixmap;
class QScrollBar;

class KviFrame;
class KviIrcUser;
class KviIrcUserChanList;
class KviUserParser;
class KviWindow;

class KviUserListBox : public QWidget
{
	Q_OBJECT
public:
	KviUserListBox(QWidget *parent, KviWindow *parentWnd, KviUserParser *parser, KviFrame *pFrm);
	~KviUserListBox();

	void partAll();
	void join(
		const KviIrcUser &user, char bOp = 0, char bVoice = 0, char bHalfOp = 0,
		char bUserOp = 0, char bOwner = 0, bool bRepaint = true
	);
	void part(const char *nick);
	void part(const KviIrcUser &user);
	void select(const char *nick);
	void select(const KviIrcUser &user);
	void selectAll();
	void deselect(const char *nick);
	void deselect(const KviIrcUser &user);
	void deselectAll();
	bool owner(const KviIrcUser &user, char bOwner);
	bool owner(const char *nick, char bOwner);
	bool op(const KviIrcUser &user, char bOp);
	bool op(const char *nick, char bOp);
	bool halfop(const KviIrcUser &user, char bHalfOp);
	bool halfop(const char *nick, char bHalfOp);
	bool nickChange(const KviIrcUser &nicker, const char *nick);
	bool voice(const KviIrcUser &user, char bVoice);
	bool voice(const char *nick, char bVoice);
	bool userop(const KviIrcUser &user, char bUserOp);
	bool userop(const char *nick, char bUserOp);

	QPtrList<KviStr> *createNickStringList();

	// Redirects
	bool isOwner(const KviIrcUser &user);
	bool isOwner(const char *nick);
	bool isOp(const KviIrcUser &user);
	bool isOp(const char *nick);
	bool isHalfOp(const KviIrcUser &user);
	bool isHalfOp(const char *nick);
	bool isVoice(const KviIrcUser &user);
	bool isVoice(const char *nick);
	bool isUserOp(const KviIrcUser &user);
	bool isUserOp(const char *nick);

	int count();
	int ownerCount();
	int opCount();
	int halfopCount();
	int voiceCount();
	int useropCount();
	int findUserPosition(const char *nick);

	KviIrcUser *findUser(const KviIrcUser &user);
	KviIrcUser *findUser(const char *nick);
	KviIrcUser *firstUser();
	KviIrcUser *lastUser();
	KviIrcUser *nextUser();
	KviIrcUser *prevUser();
	KviIrcUser *firstOp();

	KviIrcUserChanList *userList();

	void doRepaint();

	void appendSelectedNicknames(KviStr &buffer);
	void     appendSelectedMasks(KviStr &buffer);
	void     appendSelectedHosts(KviStr &buffer);
	void appendSelectedUsernames(KviStr &buffer);

	void   appendNickList(KviStr &str);
	void  appendOwnerList(KviStr &str);
	void     appendOpList(KviStr &str);
	void    appendNOpList(KviStr &str);
	void appendHalfOpList(KviStr &str);
	void  appendVoiceList(KviStr &str);
	void appendUserOpList(KviStr &str);

	virtual void wheelEvent(QWheelEvent *);
signals:
	void rightClicked();
protected slots:
	void scrollBarMoved(int value);
	int itemFromPos(QPoint pos);
protected:
	KviFrame           *m_pFrm;
	QPixmap            *m_pMemBuffer;
	HANDLE              m_hMemBuffer;
	int                 m_iCurTopItem;
	KviIrcUserChanList *m_pClientList;
	int                 m_iLastSelectedItem;
	KviUserParser      *m_pUserParser;
	KviWindow          *m_pParent;

	void updateScrollBar();

	virtual void            paintEvent(QPaintEvent *);
	virtual void           resizeEvent(QResizeEvent *);
	virtual void       mousePressEvent(QMouseEvent *);
	virtual void        mouseMoveEvent(QMouseEvent *);
	virtual void     mouseReleaseEvent(QMouseEvent *);
	virtual void        dragEnterEvent(QDragEnterEvent *);
	virtual void         dragMoveEvent(QDragMoveEvent *);
	virtual void             dropEvent(QDropEvent *);
	virtual void mouseDoubleClickEvent(QMouseEvent *);
private:
	QScrollBar *m_pScrollBar;
};

#endif // _KVI_USERLISTBOX_H_INCLUDED_
