#ifndef _KVI_DCC_SEND_H_INCLUDED_
#define _KVI_DCC_SEND_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dcc_send.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_dcc_send_thread.h"
#include "kvi_string.h"
#include "kvi_window.h"

class KviChanLabel;
class KviDccManager;
class KviProgress;

#define KVI_DCC_SENDEVENT_ASK      0
#define KVI_DCC_SENDEVENT_RECEIVE  1
#define KVI_DCC_SENDEVENT_RENAME   2
#define KVI_DCC_SENDEVENT_RESUME   3
#define KVI_DCC_SENDEVENT_SEND     4

typedef struct KviDccSendRequestData
{
	KviStr         nick;
	KviStr         username;
	KviStr         host;
	KviStr         fileName;
	KviStr         filePath;
	KviStr         originalFileName;
	unsigned long  fileLength;
	unsigned long  uAddress;
	unsigned long  resumeValue;
	unsigned short uPort;
	KviDccManager *parent;
	int            requestType;
};

class KviDccSend : public KviWindow
{
	Q_OBJECT
public:
	KviDccSend(KviFrame *lpFrm, const char *name);
	~KviDccSend();

	void acceptDccSendRequest(KviDccSendRequestData *dccSend);
	void initiateGet();
	bool youAreListening(unsigned short uPort, const char *nick);
	void requestDccSend(KviDccSendRequestData *dccSend);
	bool resumeForCurrentSend(unsigned long uResumePos);

	KviDccSendData   *m_pDccSendData;
	KviDccSendThread *m_thread;
protected:
	virtual QPixmap *myIconPtr();

	virtual void resizeEvent(QResizeEvent *);
	virtual void applyOptions();
	        void applyLabelsOptions();
	        void setFileProgress(int prog);
	        void destroyDccSendData();
	virtual bool event(QEvent *);

	void abortThread();
protected:
	KviProgress      *m_pProgress;
	KviChanLabel     *m_pFileLabel; // Styles hack (just for the class name)
	KviChanLabel     *m_pStatLabel;
};

#endif // _KVI_DCC_SEND_H_INCLUDED_
