#ifndef _KVI_DCC_CHAT_THREAD_H_INCLUDED_
#define _KVI_DCC_CHAT_THREAD_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dcc_chat_thread.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrqueue.h>

#include "kvi_dcc_thread.h"
#include "kvi_string.h"

class KviDccChat;
class KviMutex;

typedef struct KviDccChatData
{
	KviStr             nick;
	KviStr             username;
	KviStr             host;
	KviStr             szAddress;
	unsigned long      uAddress; // An internet address in network byte order
	unsigned short     uPort;    // A port in host byte order
	KviDccChat        *parent;
	QPtrQueue<KviStr> *outQueue;
	KviMutex          *outMutex;
	KviStr             szPartialBuffer;
	KviStr             tmpBuffer;
	unsigned short int uPortToListenOn;
};

////////////////////////////////////////////////////////////////////////////////

class KviDccChatThread : public KviDccThread
{
public:
	KviDccChatThread(KviDccChatData *);
	~KviDccChatThread();

	void eventLoop();

	void checkForIncomingData();
	void checkForOutgoingData();
protected:
	KviDccChatData *m_pData;
};

////////////////////////////////////////////////////////////////////////////////

class KviDccChatAcceptThread : public KviDccChatThread
{
public:
	KviDccChatAcceptThread(KviDccChatData *);
	~KviDccChatAcceptThread();

	virtual void run();
};

////////////////////////////////////////////////////////////////////////////////

class KviDccChatRequestThread : public KviDccChatThread
{
public:
	KviDccChatRequestThread(KviDccChatData *);
	~KviDccChatRequestThread();

	virtual void run();
};

#endif // _KVI_DCC_CHAT_THREAD_H_INCLUDED_
