// =============================================================================
//
//      --- kvi_fieldeditor.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviFieldEditor"

#include "kvi_fieldeditor.h"

KviFieldEditor::KviFieldEditor(QWidget *parent)
	: KviLineEdit(parent)
{
	hide();
}

KviFieldEditor::~KviFieldEditor()
{
	// Nothing here
}

void KviFieldEditor::edit(const QString &str, bool bEnd)
{
	setText(str);
	if( bEnd )
		end(false);
	else
		home(false);
	show();
	setFocus();
}

void KviFieldEditor::keyPressEvent(QKeyEvent *e)
{
	if( (e->key() == Qt::Key_Return) || (e->key() == Qt::Key_Enter) ) {
		KviLineEdit::keyPressEvent(e);
		terminateEdit(true);
		e->accept();
	} else if( e->key() == Qt::Key_Escape ) {
		KviLineEdit::keyPressEvent(e);
		terminateEdit(false);
		e->accept();
	} else if( e->key() == Qt::Key_Up ) {
		KviLineEdit::keyPressEvent(e);
		emit keyUpPressed();
		e->accept();
	} else if( e->key() == Qt::Key_Down ) {
		KviLineEdit::keyPressEvent(e);
		emit keyDownPressed();
		e->accept();
	} else if( e->key() == Qt::Key_Right ) {
		if( (unsigned int) cursorPosition() == text().length() ) {
			KviLineEdit::keyPressEvent(e);
			emit keyRightPressed();
			e->accept();
		} else KviLineEdit::keyPressEvent(e);
	} else if( e->key() == Qt::Key_Left ) {
		if( cursorPosition() == 0 ) {
			KviLineEdit::keyPressEvent(e);
			emit keyLeftPressed();
			e->accept();
		} else KviLineEdit::keyPressEvent(e);
	} else KviLineEdit::keyPressEvent(e);
}

void KviFieldEditor::mousePressEvent(QMouseEvent *e)
{
	// If the mouse is outside of this widget release...
	if( !rect().contains(e->pos()) )
		terminateEdit(true);
	else
		KviLineEdit::mousePressEvent(e);
}

void KviFieldEditor::terminateEdit(bool bCommitChanges)
{
	if( isVisible() ) {
		hide();
		if( bCommitChanges ) emit editFinished(text());
		setText("");
	}
}

void KviFieldEditor::focusOutEvent(QFocusEvent *)
{
	terminateEdit(true);
}

#include "m_kvi_fieldeditor.moc"
