// =============================================================================
//
//      --- kvi_charselector.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviCharSelector"

#include <qobjectlist.h>

#include "kvi_charselector.h"
#include "kvi_debug.h"
#include "kvi_label.h"
#include "kvi_lineedit.h"
#include "kvi_string.h"

KviCharSelector::KviCharSelector(
	QWidget *parent, const char *description, char *pChar, bool bEnabled, int fieldWidth, const char *name)
	: QWidget(parent, name)
{
	__range_valid(pChar);
	m_pChar = pChar;

	m_pLabel = new KviLabel(_CHAR_2_QSTRING(description), this);
	m_pEdit  = new KviLineEdit(this);
	KviStr tmp;
	tmp.append(*pChar);
	m_pEdit->setText(tmp.ptr());
	m_iFieldWidth = (fieldWidth > 0) ? fieldWidth : 20;
	setMinimumWidth(m_iFieldWidth + m_pLabel->sizeHint().width() + 1);
	setMinimumHeight(m_pEdit->sizeHint().height());
	setEnabled(bEnabled);
}

KviCharSelector::~KviCharSelector()
{
	// Nothing here
}

void KviCharSelector::commitChanges()
{
	KviStr tmp = m_pEdit->text();
	if( tmp.hasData() )
		*m_pChar = *(tmp.ptr());
	else
		*m_pChar = '/';
}

void KviCharSelector::commitAll(QWidget *w)
{
	QObjectList *l = w->queryList("KviCharSelector");
	if( !l ) return;
	QObjectListIt it(*l);
	while( it.current() ) {
		((KviCharSelector *) it.current())->commitChanges();
		++it;
	}
	delete l;
}

void KviCharSelector::resizeEvent(QResizeEvent *)
{
	m_pEdit->setGeometry(width() - m_iFieldWidth, 0, m_iFieldWidth, height());
	m_pLabel->setGeometry(0, 0, width() - (m_iFieldWidth + 1), height());
}

QSize KviCharSelector::sizeHint()
{
	return QSize(m_pLabel->sizeHint().width() + m_iFieldWidth + 1, m_pEdit->sizeHint().height());
}

void KviCharSelector::setEnabled(bool bEnabled)
{
	m_pLabel->setEnabled(bEnabled);
	m_pEdit->setEnabled(bEnabled);
	QWidget::setEnabled(bEnabled);
}

#include "m_kvi_charselector.moc"
