// =============================================================================
//
//      --- kvi_toolbar_kde.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qtooltip.h>

#include <ktoolbarbutton.h>

#include "kvi_iconloader.h"
#include "kvi_mainwindow.h"
#include "kvi_toolbar_kde.h"

KviToolBar::KviToolBar(const QString &, KviMainWindow *mainWindow, QWidget *parent, Qt::Dock dock, bool nl, const char *name)
	: KToolBar(mainWindow, parent, nl, name)
{
	m_bPreferOwnIcons = false;
	m_buttonIcons.setAutoDelete(true);
	if( mainWindow )
		mainWindow->addDockWindow(this, dock, nl);
	setEnableContextMenu(false);
}

KviToolBar::~KviToolBar()
{
	// Nothing here
}

int KviToolBar::insertButton(
	const QString &icon, int id, const char *signal, const QObject *receiver, const char *slot,
	bool enabled, const QString &text, const QString &tooltip)
{
	int index = KToolBar::insertButton(
		KviIconLoader::loadIcon(icon, m_bPreferOwnIcons), id, signal, receiver, slot, enabled, text
	);
	m_buttonIcons.insert(id, new QString(icon));
	QToolTip::add(getButton(id), tooltip);
	return index;
}

void KviToolBar::setPreferOwnIcons(bool useOwn)
{
	m_bPreferOwnIcons = useOwn;
}

void KviToolBar::setButtonIcon(int id, const QString &icon)
{
	m_buttonIcons.replace(id, new QString(icon));
	if( m_bPreferOwnIcons )
		setButtonIconSet(id, KviIconLoader::loadIconSet(icon, m_bPreferOwnIcons));
	else
		setButtonIconSet(id, KviIconLoader::loadIcon(icon, m_bPreferOwnIcons));
}

void KviToolBar::setButtonText(int id, const QString &text, bool tipToo)
{
	KToolBarButton *btn = getButton(id);
	if( btn )
		btn->setTextLabel(text, tipToo);
}

void KviToolBar::toggleBigIcons(bool useBig)
{
	int width = 22;
	if( useBig )
		width = 32;
	setIconSize(width);
	// Some funky workaround for KDE icon idiocy
	QIconSet::setIconSize(QIconSet::Small, QSize(width, width));
	QIntDictIterator<QString> iter(m_buttonIcons);
	for( ; iter.current(); ++iter ) {
		if( m_bPreferOwnIcons )
			setButtonIconSet(iter.currentKey(), KviIconLoader::loadIcon(*(iter.current()), m_bPreferOwnIcons));
		else
			setButtonIconSet(iter.currentKey(), KviIconLoader::loadIconSet(*(iter.current()), m_bPreferOwnIcons));
	}
}

void KviToolBar::toggleIconText(bool on)
{
	if( on )
		setIconText(IconTextBottom);
	else
		setIconText(IconOnly);
}

#include "m_kvi_toolbar_kde.moc"
