//
//   File : optw_privmsg.cpp
//   Creation date : Sat Nov  3 06:14:53 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include "optw_privmsg.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"


KviPrivmsgOptionsWidget::KviPrivmsgOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"privmsg_options_widget")
{
	createLayout(10,2);

	KviBoolSelector * b1;
	KviBoolSelector * b2;

	b1 = addBoolSelector(0,0,1,0,__tr2qs_ctx("\"Smart\" nickname colors","options"),KviOption_boolColorNicks);
	b2 = addBoolSelector(0,1,1,1,__tr2qs_ctx("Use same colors as in the userlist","options"),KviOption_boolUseUserListColorsAsNickColors,!KVI_OPTION_BOOL(KviOption_boolColorNicks));
	connect(b1,SIGNAL(toggled(bool)),b2,SLOT(setNotEnabled(bool)));
	addBoolSelector(0,2,1,2,__tr2qs_ctx("Show nicknames in bold","options"),KviOption_boolBoldedNicks);
	addBoolSelector(0,3,1,3,__tr2qs_ctx("Show user and host","options"),KviOption_boolShowUserAndHostInPrivmsgView);
	addBoolSelector(0,4,1,4,__tr2qs_ctx("Show channel mode prefix","options"),KviOption_boolShowChannelUserFlagInPrivmsgView);
	KviBoolSelector * b = addBoolSelector(0,5,1,5,__tr2qs_ctx("User-defined prefix and postfix","options"),KviOption_boolUseExtendedPrivmsgView);

	QLabel * l = addLabel(0,6,1,6,__tr2qs_ctx("[PREFIX]nickname[!user@host][POSTFIX] message","options"));

	l->setEnabled(KVI_OPTION_BOOL(KviOption_boolUseExtendedPrivmsgView));
	connect(b,
		SIGNAL(toggled(bool)),
		l,
		SLOT(setEnabled(bool)));

	connect(
		b,
		SIGNAL(toggled(bool)),
		addStringSelector(0,7,0,7,__tr2qs_ctx("Prefix:","options"),KviOption_stringExtendedPrivmsgPrefix,KVI_OPTION_BOOL(KviOption_boolUseExtendedPrivmsgView)),
		SLOT(setEnabled(bool)));
	connect(
		b,
		SIGNAL(toggled(bool)),
		addStringSelector(1,7,1,7,__tr2qs_ctx("Postfix:","options"),KviOption_stringExtendedPrivmsgPostfix,KVI_OPTION_BOOL(KviOption_boolUseExtendedPrivmsgView)),
		SLOT(setEnabled(bool)));

	addBoolSelector(0,8,1,8,__tr2qs_ctx("Don't show colors in user messages","options"),KviOption_boolStripMircColorsInUserMessages);
	
	addRowSpacer(0,9,1,9);
}

KviPrivmsgOptionsWidget::~KviPrivmsgOptionsWidget()
{
}


#include "m_optw_privmsg.moc"
