//
//   SPEAK plugin for KVirc 1.1 Phoenix.
//
//   This plugin enables you to use IBM's ViaVoiceOutloud to speak
//   messages to you.  Messages that are directed to you, over the
//   Relay Chat, can be spoken outloud or sentences spoken by specific
//   people can also heard outloud.
//
//   To use the plugin, one needs to have a working IBM ViaVoice
//   Outloud, which can be retrieved from IBM's site.  For information
//   about IBM ViaVoice http://www-4.ibm.com/software/speech/dev/
//
//   Copyright (C) rn E. Hansen (oe.hansen@gamma.telenordia.se)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef smileyClassData_included
#define smileyClassData_included

#include <qdialog.h>
#include <qcheckbox.h>
#include <qlistview.h>
#include <qlineedit.h>

class smileyClassData : public QDialog
{
    Q_OBJECT

public:

    smileyClassData(QWidget *parent = NULL, const char *name = NULL);

    virtual ~smileyClassData();

    protected slots:

    virtual void loadBase() =0;
    virtual void insertItem() =0;
    virtual void removeItem() =0;
    virtual void okPressed() =0;
    virtual void updateItem() =0;
    virtual void saveBaseAs() =0;
    virtual void selectShortHand(QListViewItem*) =0;

    protected:

    QListView *m_pShortHands;
    QLineEdit *m_pShortText;
    QLineEdit *m_pSpokenText;
    QCheckBox *m_pCaseSensation;
};

#endif // smileyClassData_included
