/**vim: ts=4, wrap, tw=80
  *
  *		--- libkvibiffsystray.cpp ---
  *
  * Authors:
  * 	Krzysztof Godlewski <kristoff@poczta.wprost.pl>
  * 	Szymon Stefanek <stefanek@tin.it>
  * 
  * This program is FREE software. You can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your opinion) any later version.
  *
  * This program is distributed in the HOPE that it will be USEFUL,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program. If not, write to the Free Software Foundation,
  * Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **/
 
#define __KVIRC_PLUGIN__

#include "kvirc_plugin.h"
#include "kvi_locale.h"
#include "kvi_systray.h"

#include "libkvibiff.h"
#include "libkvibiffsystray.h"

#include <qpopupmenu.h>
#include <qobjcoll.h>

#define BIFF_NULL_STRING		"[!-NULL-!]"

extern KviBiff * g_pBiff;
extern Display * g_display;

KviBiffWidget::KviBiffWidget(KviSysTray * parent, KviFrame * frm,
	const char *tooltip) : KviSysTrayWidget(parent,tooltip), m_pFrm(frm),
	m_popup(new QPopupMenu(0)), m_mBoxPopup(new QPopupMenu(0)),
	m_pTextTimer(new QTimer(this))
{
	g_pBiff->registerSysTrayWidget(this);
//
// Create the popup menu:
	connect( m_mBoxPopup, SIGNAL(aboutToShow()), SLOT(fillMailboxPopup()));

	m_popup->insertItem( __tr("Check mail in"), m_mBoxPopup );
//
// FIXME:Need to look into this too...
//	m_popup->insertItem( __tr("Check all mailboxes"), g_pBiff,
//		SLOT(slotCheckAll()));
	m_popup->insertItem( __tr("Configure mailboxes"), g_pBiff,
		SLOT(slotConfigureMailboxes()) );
	m_popup->insertItem( __tr("Configure plugin"), g_pBiff, SLOT(slotConfig()));
	m_popup->insertSeparator();
//
// FIXME:Some problems in this one... Sometimes the app freezes after doing that
//	m_popup->insertItem( __tr("Stop checking mail"), g_pBiff, 
//		SLOT(stopCheckingMail()));
	m_popup->insertItem( __tr("Hide this widget"), this, SLOT( slotHide()));
	
	m_textToShow.sprintf(BIFF_NULL_STRING);
}

KviBiffWidget::~KviBiffWidget()
{
	g_pBiff->unregisterSysTrayWidget(this);
}

QPixmap * KviBiffWidget::icon()
{
	return g_pBiff->currentWidgetIcon();
}

void KviBiffWidget::paintEvent( QPaintEvent *ev )
{
	if( ! isVisibleToTLW() )
		return;

	HANDLE hMemBuf = m_pSysTray->getMemoryBufferHandle();
	GC the_gc = XCreateGC( g_display, hMemBuf, 0, 0 );

	paintDefaultBackground( hMemBuf, the_gc );
	XSetForeground(g_display, the_gc, m_pSysTray->getForegroundPixel());


	KviStr s, s2 = BIFF_NULL_STRING;
	if( m_showingText && ! kvi_strEqualCS(m_textToShow.ptr(),BIFF_NULL_STRING))
	{
		if( m_textToShow.contains( '\n' ))
		{
			s = m_textToShow.left(m_textToShow.findFirstIdx('\n'));
			s2 = m_textToShow.middle(m_textToShow.findFirstIdx('\n') + 1, 100);
		}
		else
			s = m_textToShow;
	}
	else
	{
		s.sprintf( "*** The Biff Plugin ***" );
		s2.sprintf( "Press right mouse button for menu.");
	}

//
// Big mode
	if( height() > 32 )
	{
		g_pOptions->m_fntSysTray.setPointSize(12);
		XSetFont(g_display, the_gc, g_pOptions->m_fntSysTray.handle());

		XDrawString(g_display,hMemBuf,the_gc,4,height() - 24,s.ptr(),s.len());
		if( ! kvi_strEqualCS(s2.ptr(), BIFF_NULL_STRING) )
		{
		//	g_pOptions->m_fntSysTray.setPointSize(12);
		//	XSetFont(g_display, the_gc, g_pOptions->m_fntSysTray.handle());
			XDrawString(g_display, hMemBuf, the_gc, 4, height() - 8, s2.ptr(),
				s2.len());
		}
	}
//
// Small mode
	else
	{
		if( ! kvi_strEqualCS(s2.ptr(), BIFF_NULL_STRING ))
			s.append(" " + s2);
		g_pOptions->m_fntSysTray.setPointSize(12);
		XSetFont(g_display, the_gc, g_pOptions->m_fntSysTray.handle());
		XDrawString(g_display,hMemBuf,the_gc,4,height() - 6,s.ptr(),s.len());
	}

	paintDefaultFrame( hMemBuf, the_gc );
	XCopyArea(g_display,hMemBuf,handle(),the_gc,0,0,width(),height(),0,0);
	XFreeGC( g_display, the_gc );
}

void KviBiffWidget::timerEvent( QTimerEvent *ev )
{
// FIXME: for future scrolling implementation (and interval mail checking ?)
}

void KviBiffWidget::mousePressEvent( QMouseEvent *ev )
{
	switch( ev->button() )
	{
		case QMouseEvent::RightButton:
			m_popup->exec( QCursor::pos() );
			break;

		default:
			break;
	}
}

void KviBiffWidget::slotHide()
{
	m_pSysTray->removeWidget(this, true );
}

void KviBiffWidget::showText( const char *text, uint time, bool p )
{
	m_textToShow = text;
	m_showingText = true;
	repaint(false);
	if( m_pTextTimer->isActive())
		m_pTextTimer->stop();
	if(!p)		// message not permanent
	{
		m_pTextTimer->start(time);
		connect( m_pTextTimer, SIGNAL(timeout()), SLOT(showOrginalText()));
	}
//
// Find this systray's icon display, to force paint event. 
	QObjectList *list = m_pSysTray->queryList("KviSysTrayIconDisplay", 0,
		false, true);
	QObjectListIt it(*list);
	KviSysTrayIconDisplay *id = (KviSysTrayIconDisplay *)it.current();
	if( id )
	{
		id->setIcon(icon());
		id->repaint(true);
	}
	else
		debug( "[biff]: Couldn't find KviSysTrayIconDisplay in m_pSysTray " \
			"children list. Icon will not be correctly changed." );
}

void KviBiffWidget::showOrginalText()
{
	m_showingText = false;
	m_textToShow.sprintf(BIFF_NULL_STRING);
	repaint(false);
}

void KviBiffWidget::fillMailboxPopup()
{
	m_mBoxPopup->clear();
	for( KviBiffMailbox *m = g_pBiff->mailboxList()->first(); m;
			m = g_pBiff->mailboxList()->next())
	{
		KviStr s;
		s.sprintf( "%s@%s", m->username(), m->hostname());
// The popup-id of inserted item will be correct mailbox's index in the list
// (m_pMailboxList in g_pBiff)
		int id = g_pBiff->mailboxList()->find(m);
		m_mBoxPopup->insertItem( s.ptr(), g_pBiff,
			SLOT( slotCheckMailIn(int)), 0, id);
	}
}

#include "libkvibiffsystray.moc"
