#ifndef _KVI_SLAVEIO_H_INCLUDED_
#define _KVI_SLAVEIO_H_INCLUDED_

//
//   File : kvi_slaveio.h (/usr/build/KVICVS/kvirc/src/kvirc/kvi_slaveio.h)
//   Last major modification : Tue Sep 21 1999 14:25:22 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qobject.h>
#include <qlist.h>

#include "kvi_string.h"
#include "kvi_process.h"
#include "kvi_window.h"

class KviFrame;
class KviUserParser;

typedef struct KviSlaveProcEntryTag
{
	KviProcess * proc;
//	KviWindow  * sayToWindow;
	KviStr       commandline;
	unsigned long int uPid;
	bool         bRunsInSubshell;
	bool         bQuiet;
	KviStr       asyncCmd;
	bool         bAsyncCmd;
	KviStr       stdoutBuffer;
	KviStr       stderrBuffer;
	KviStr       magic;
	KviStr       window;
} KviSlaveProcEntry;

class KviSlaveIO : public QObject
{
	Q_OBJECT
public:
	KviSlaveIO(KviFrame * pFrm,KviUserParser * pParser);
	~KviSlaveIO();
protected:
	KviFrame * m_pFrm;
	QList<KviSlaveProcEntry> * m_pProcList;
	KviUserParser * m_pUserParser;
public:
	bool killProcess(unsigned long int pid);
	int killAll();
	KviSlaveProcEntry * findProcByPid(unsigned long int pid);
	KviSlaveProcEntry * findProcByPtr(KviProcess * proc);
	bool exec(const char *commandline,KviWindow * w,bool bExecInSubshell = false,bool bQuiet = false,const char *asyncCmd = 0,const char *magic = 0);
	void outputProcessList(KviWindow * w);
	bool writeProcess(KviSlaveProcEntry * e,const char *buffer,int len);
protected slots:
	void procExited(KviProcess * proc,int status);
	void procStdout(KviProcess * proc,char * buffer,int buflen);
	void procStderr(KviProcess * proc,char * buffer,int buflen);
};

#endif //!_KVI_SLAVEIO_H_INCLUDED_
