#ifndef _KVI_PLUGIN_H_INCLUDED_
#define _KVI_PLUGIN_H_INCLUDED_

//
//   File : kvi_plugin.h (/usr/build/KVIrc/kvirc/src/kvilib/kvi_plugin.h)
//   Last major modification : Wed Jul 21 1999 16:41:14 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#ifdef COMPILE_PLUGIN_SUPPORT

#ifndef __KVIRC_PLUGIN__
	#include "../plugins/kvirc_plugin.h"
#endif

#include "kvi_string.h"

#include <qlist.h>

class KviSysTrayWidget;
class KviDockableWidget;

typedef struct KviPluginData
{
	KviStr filename;
	KviPlugin * description;
	void * handle;
	bool bAutoload;
	bool bInitExecuted;
};

typedef struct KviPluginCommandHandler
{
	KviStr cmd_name;
	bool (*handler_routine)(KviPluginCommandStruct *);
	void * plugin_handle;
};

typedef struct KviPluginFunctionHandler
{
	KviStr fnc_name;
	bool (*handler_routine)(KviPluginCommandStruct *,KviStr *);
	void * plugin_handle;
};

class KviPluginManager
{
public:
	KviPluginManager();
	~KviPluginManager();
protected:
	QList<KviPluginData> * m_pPluginList;
	QList<KviPluginCommandHandler> * m_pCommandList;
	QList<KviPluginFunctionHandler> * m_pFunctionList;
public:
	inline QList<KviPluginData> * pluginList(){ return m_pPluginList; };
	KviPluginData * findPlugin(void * plugin_handle);
	KviPluginData * findPlugin(const char *fName);
	KviPluginData * findPluginByModuleName(const char *name);
	KviPluginData * loadPlugin(const char *fName,bool bAutoload = true,KviStr * pErrorRet = 0);
	bool executeInitRoutine(KviPluginData * data,KviPluginCommandStruct * cmd);
	void getLastError(KviStr &buffer);
	bool unloadPlugin(const char *fName);
	bool unloadPluginByModuleName(const char *fName);

//	bool unloadPlugin(void * plugin_handle);

	void unregisterCommandsFor(void * plugin_handle);
	void registerCommand(void * plugin_handle,const char * cmdname,
			bool (*handler_routine)(KviPluginCommandStruct *));
	void unregisterCommand(void * plugin_handle,const char * cmdname);
	KviPluginCommandHandler * findCommandHandler(const char *cmdname);

	void registerFunction(void * plugin_handle,const char *fncname,
			bool (*handler_routine)(KviPluginCommandStruct *,KviStr *));
	void unregisterFunction(void * plugin_handle,const char * fncname);
	void unregisterFunctionsFor(void * plugin_handle);
	KviPluginFunctionHandler * findFunctionHandler(const char *fncname);

	void unregisterHooksFor(void * plugin_handle);
	void unregisterHook(void * plugin_handle,int eventindex);
	void registerHook(void * plugin_handle,int eventindex,
			bool (*handler_routine)(KviPluginCommandStruct *));
	bool isHookRegistered(void * plugin_handle,int eventindex);

	void addPluginWindow(void * plugin_handle,KviFrame * frame,KviWindow *wnd,bool bShow = true);
	void removeAllPluginWindows(void * plugin_handle);

	void addPluginDockedWidget(void * plugin_handle,KviFrame * frame,KviDockableWidget * w);
	void removeAllPluginDockedWidgets(void * plugin_handle);

	void addPluginSysTrayWidget(void * plugin_handle,KviFrame * frame,KviSysTrayWidget * w, bool _show = true);
	void removeAllPluginSysTrayWidgets(void * plugin_handle);

	void unregisterMetaObject(const char * metaObjName);

	bool load(const char *configName,KviStr &error);
	bool save(const char *configName);
private:
	void unloadPluginInternal(KviPluginData *d);
};



#endif //COMPILE_PLUGIN_SUPPORT

#endif //_KVI_PLUGIN_H_INCLUDED_
