//
//   File : kvi_menubar.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_menubar.h)
//   Last major modification : Tue Jul 6 1999 14:46:43 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#ifndef _KVI_MENUBAR_H_INCLUDED_
#define _KVI_MENUBAR_H_INCLUDED_

#include <qmenubar.h>

class KviFrame;

class KviMenuBar : public QMenuBar
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviMenuBar(KviFrame *par);
	~KviMenuBar();
public:
	KviFrame * m_pFrm;
	QPopupMenu * m_pOnlinePopup;
	QPopupMenu * m_pMainPopup;
	QPopupMenu * m_pToolsPopup;
	int m_iOnlinePopupId;
	int m_iConnectItemId;
	int m_iDockWidgetId;
public:
	void setConnectItemState(bool bIsOnline);
	void enableOnLinePopup(bool bEnable);
	void wmDockWidgetStateChanged(bool bIsVisible);
	virtual void drawContents(QPainter *p);
	virtual void setBackgroundPixmap(const QPixmap &pm);
	virtual void setPalette(const QPalette & pal);
	virtual void setBackgroundMode(QWidget::BackgroundMode bk);
protected slots:
	void fillToolsPopup();
};

#endif //_KVI_MENUBAR_H_INCLUDED_
