#ifndef _KVI_ERROR_H_INCLUDED_
#define _KVI_ERROR_H_INCLUDED_

//
//   File : kvi_error.h (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_error.h)
//   Last major modification : Mon Jan 11 1999 02:41:58 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


//Generic errors
#define KVI_ERROR_NoError 0
#define KVI_ERROR_Success 0
#define KVI_ERROR_UnknownError 1

//Errors used by kvi_dns.cpp

#define KVI_ERROR_NoChildProcess 2
#define KVI_ERROR_NoHostToResolve 3
#define KVI_ERROR_HostNotFound 4
#define KVI_ERROR_ValidNameButNoIpAddress 5
#define KVI_ERROR_UnrecoverableNameserverError 6
#define KVI_ERROR_DnsTemporaneousFault 7
#define KVI_ERROR_DnsQueryFailed 8

//Errors used by kvi_socket.cpp

#define KVI_ERROR_InvalidIpAddress 9
#define KVI_ERROR_AnotherConnectionInProgress 10
#define KVI_ERROR_SocketCreationFailed 11
#define KVI_ERROR_AsyncSocketFailed 12

#define KVI_ERROR_BadFileDescriptor 13
#define KVI_ERROR_OutOfAddressSpace 14
#define KVI_ERROR_KernelNetworkingPanic 15
#define KVI_ERROR_ConnectionRefused 16
#define KVI_ERROR_ConnectionTimedOut 17
#define KVI_ERROR_NetworkUnreachable 18
#define KVI_ERROR_RemoteEndClosedConnection 19
#define KVI_ERROR_NotConnectedToServer 20
#define KVI_ERROR_BrokenPipe 21
#define KVI_ERROR_NoServerEntries 22
#define KVI_ERROR_GetsocknameFailed 23
#define KVI_ERROR_InvalidProxyAddress 24
#define KVI_ERROR_UnrecognizedProxyReply 25
#define KVI_ERROR_ProxyConnectionRejected 26
#define KVI_ERROR_ProxyNoAcceptableMethods 27
#define KVI_ERROR_ProxyAuthFailed 28
#define KVI_ERROR_ProxyReply01GeneralSOCKSFailure 29
#define KVI_ERROR_ProxyReply02ConnectionNotAllowed 30
#define KVI_ERROR_ProxyReply03NetworkUnreachable 31
#define KVI_ERROR_ProxyReply04HostUnreachable 32
#define KVI_ERROR_ProxyReply05ConnectionRefused 33
#define KVI_ERROR_ProxyReply06TTLExpired 34
#define KVI_ERROR_ProxyReply07CommandNotSupported 35
#define KVI_ERROR_ProxyReply08AddressTypeNotSupported 36
#define KVI_ERROR_ProxyReply09InvalidAddress 37
#define KVI_ERROR_ProxyReply91RequestFailed 38
#define KVI_ERROR_ProxyReply92IdentFailed 39
#define KVI_ERROR_ProxyReply93IdentNotMatching 40

#define KVI_ERROR_CompiledWithNoSound 41
//#define KVI_ERROR_Dummy41 41
#define KVI_ERROR_SoundCardAlreadyOpen 42
//#define KVI_ERROR_Dummy42 42
#define KVI_ERROR_CanNotOpenDevDsp 43
//#define KVI_ERROR_Dummy43 43
#define KVI_ERROR_CanNotInitializeSoundCard 44
//#define KVI_ERROR_Dummy44 44
#define KVI_ERROR_MissingFileName 45
//#define KVI_ERROR_Dummy45 45

// Errors for the command parser

#define KVI_ERROR_MissingClosingBrace 46
#define KVI_ERROR_UnknownCommand 47
#define KVI_ERROR_MissingVariableName 48
#define KVI_ERROR_UnknownOperator 49
#define KVI_ERROR_UnknownIdentifier 50
#define KVI_ERROR_UnknownFunction 51
#define KVI_ERROR_UnexpectedEndOfCommand 52
#define KVI_ERROR_MissingOperator 53
#define KVI_ERROR_MissingWindowName 54
#define KVI_ERROR_WindowNotFound 55
#define KVI_ERROR_MissingIconNumber 56
#define KVI_ERROR_InvalidOption 57
#define KVI_ERROR_CantFindHelpFiles 58
#define KVI_ERROR_NoHelpAvailable 59
#define KVI_ERROR_CantOpenFileForReading 60
#define KVI_ERROR_LeftOperandIsNotANumber 61
#define KVI_ERROR_RightOperandIsNotANumber 62
#define KVI_ERROR_LeftOperandIsUndefined 63
#define KVI_ERROR_ParenthesisMismatch 64
#define KVI_ERROR_UnexpectedCharacter 65
#define KVI_ERROR_InternalError 66
#define KVI_ERROR_MissingCommandAfterElse 67
#define KVI_ERROR_OpenParenthesisExpected 68
#define KVI_ERROR_MissingCommandAfterWhile 69
#define KVI_ERROR_SingleStringOperand 70
#define KVI_ERROR_OperandDoesNotMatchOperator 71
#define KVI_ERROR_DivisionByZero 72
#define KVI_ERROR_UnexpectedEndInString 73
#define KVI_ERROR_DoWithoutWhile 74
#define KVI_ERROR_CommandTerminatorExpected 75
#define KVI_ERROR_MissingDialogType 76
#define KVI_ERROR_UnknownDialogType 77
#define KVI_ERROR_AliasNameExpected 78
#define KVI_ERROR_AliasBodyExpected 79
#define KVI_ERROR_MissingChannelName 80
#define KVI_ERROR_ModeRequiresParameters 81
#define KVI_ERROR_OpenBraceExpected 82
#define KVI_ERROR_CaseDefaultMatchOrEndOfSwitchExpected 83
#define KVI_ERROR_CommandExpectedAfterDefault 84
#define KVI_ERROR_CommandExpectedAfterCase 85
#define KVI_ERROR_EndOfSwitchExpectedAfterDefault 86
#define KVI_ERROR_CommandExpectedAfterMatch 87
#define KVI_ERROR_NickRequiresANick 88
#define KVI_ERROR_PopupItemCommandExpected 89
#define KVI_ERROR_ItemPopupOrSeparatorExpected 90
#define KVI_ERROR_UnknownPopup 91
#define KVI_ERROR_ThisIsNotAChannel 92
#define KVI_ERROR_MissingTarget 93
#define KVI_ERROR_WhoQueriesRequireANick 94
#define KVI_ERROR_MissingCtcpType 95
#define KVI_ERROR_ThisIsNotAQueryNorChannel 96
#define KVI_ERROR_LogOnOffRequired 97
#define KVI_ERROR_CantStartLoggingInThisWindow 98
#define KVI_ERROR_CantStartLogging 99
#define KVI_ERROR_CanNotStartDnsThread 100
#define KVI_ERROR_UnsupportedDccType 101
#define KVI_ERROR_MissingMask 102
#define KVI_ERROR_AlreadyRegistered 103
#define KVI_ERROR_InvalidRegistrationMask 104
#define KVI_ERROR_RegistrationWillBeResetByDialog 105
#define KVI_ERROR_UserNotRegistered 106
#define KVI_ERROR_AliasSelfModificationNotAllowed 107
#define KVI_ERROR_PopupSelfModificationNotAllowed 108
#define KVI_ERROR_NotAValidScriptFile 109
#define KVI_ERROR_StringLengthExpected 110
#define KVI_ERROR_StringIndexExpected 111
#define KVI_ERROR_MissingTimeout 112
#define KVI_ERROR_NoMimeTypeMatching 113
#define KVI_ERROR_NoCommandlineForMimeType 114
#define KVI_ERROR_MissingTimerName 115
#define KVI_ERROR_InvalidTimeout 116
#define KVI_ERROR_InvalidPort 117
#define KVI_ERROR_NoMatchingTimers 118
#define KVI_ERROR_MissingOptionName		119
#define KVI_ERROR_NoSuchOption			120
#define KVI_ERROR_MissingOptionValue	121
#define KVI_ERROR_InvalidOptionType		122
#define KVI_ERROR_NoAliasWithThatName   123
#define KVI_ERROR_InvalidRangeValue 124
#define KVI_ERROR_MissingCommandline 125
#define KVI_ERROR_ProcessStartFailed 126
#define KVI_ERROR_MissingWindowOperation 127
#define KVI_ERROR_UnknownWindowOperation 128
#define KVI_ERROR_ThisWindowHasNoTextBuffer 129
#define KVI_ERROR_WindowPositionXYExpected 130
#define KVI_ERROR_WindowSizeExpected 131
#define KVI_ERROR_UnknownImageFormat 132
#define KVI_ERROR_UnableToSaveBuffer 133
#define KVI_ERROR_MissingNickname 134
#define KVI_ERROR_UnsignedIntegerExpected 135
#define KVI_ERROR_ConfigFilePathExpected 136
#define KVI_ERROR_InvalidConfigType 137
#define KVI_ERROR_ThisWindowHasNoCommandline 138
#define KVI_ERROR_MissingPitch 139
#define KVI_ERROR_MissingDuration 140
#define KVI_ERROR_ChannelNotFound 141
#define KVI_ERROR_MissingDirName 142
#define KVI_ERROR_CantListDirContents 143
#define KVI_ERROR_InvalidDirectory 144
#define KVI_ERROR_CantCDInThatDirectory 145
#define KVI_ERROR_MissingPid 146
#define KVI_ERROR_NoSuchProcess 147
#define KVI_ERROR_CantWriteToProcess 148
#define KVI_ERROR_InvalidWindowName 149
#define KVI_ERROR_MissingDictionaryKey 150
#define KVI_ERROR_MissingDictionaryName 151
#define KVI_ERROR_PluginFilePathExpected 152
#define KVI_ERROR_InvalidPluginOperation 153
#define KVI_ERROR_NoPluginSupport 154
#define KVI_ERROR_NoSuchPlugin 155
#define KVI_ERROR_CantLoadPlugin 156
#define KVI_ERROR_CantExecutePluginInitRoutine 157
// generic errors for plugins
#define KVI_ERROR_MissingParameter 158
#define KVI_ERROR_InvalidParameter 159
#define KVI_ERROR_InvalidOperation 160
#define KVI_ERROR_MissingKey 161
#define KVI_ERROR_MissingSection 162
#define KVI_ERROR_UtoolbarCommandExpected 163
#define KVI_ERROR_MissingCommandBlockToTry 164
#define KVI_ERROR_CantOpenFileForWriting 165
#define KVI_ERROR_MissingObjectClass 166
#define KVI_ERROR_MissingObjectName 167
#define KVI_ERROR_MissingObjectParent 168
#define KVI_ERROR_UnknownObjectClass 169
#define KVI_ERROR_InexistingParentObject 170
#define KVI_ERROR_ObjectNotFound 171
#define KVI_ERROR_MissingObjectField 172
#define KVI_ERROR_MissingObjectId 173
#define KVI_ERROR_MissingObjectEventName 174
#define KVI_ERROR_NoSuchObjectFunction 175
#define KVI_ERROR_ObjectFunctionFailure 176
#define KVI_ERROR_ClassAlreadyDefined 177
#define KVI_ERROR_EventOrFunctionKeywordExpected 178
#define KVI_ERROR_InvalidClassOverride 179
#define KVI_ERROR_VariableOrIdentifierExpected 180
#define KVI_ERROR_NotConnected 181
#define KVI_ERROR_ObjectIsNotASocket 182
#define KVI_ERROR_NoConnectionToAccept 183
#define KVI_ERROR_NoTextToFind 184
#define KVI_ERROR_NoSuchQtProperty 185
#define KVI_ERROR_ObjectIsNotAWidget 186
#define KVI_ERROR_MissingSignalName 187
#define KVI_ERROR_MissingSlotName 188
#define KVI_ERROR_UnsupportedQtProperty 189
#define KVI_ERROR_MissingUrl 190
#define KVI_ERROR_MissingBrowserCommandlineOption 191
#define KVI_ERROR_ObjectIsNotAPopup 192
#define KVI_ERROR_MissingHostname 193
#define KVI_ERROR_MissingServicesCommand 194
#define KVI_ERROR_UserhostRequiresANick 195
#define KVI_ERROR_UserRequiresUHS 196
//#define KVI_ERROR_NoAncestorClassToSkipTo 179

#define KVI_ERROR_NUMBER_OF_ERRORS		197

#ifndef _KVI_ERROR_CPP_
//Negative errors are system errors (errno)
extern const char * kvi_getErrorString(int errorNum);
#endif //!_KVI_ERROR_CPP_

#endif //!_KVI_ERROR_H_INCLUDED_
