//
//   File : kvi_error.cpp (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_error.cpp)
//   Last major modification : Mon Jan 11 1999 02:43:14 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#define _KVI_ERROR_CPP_
#include "kvi_error.h"

#include "kvi_settings.h"

#include "kvi_string.h" // that will include string.h for strerror

#include "kvi_locale.h"

static const char * g_kviErrorStringTable[]={
	//#define KVI_ERROR_NoError 0
	_i19n_("No error"),
	//#define KVI_ERROR_UnknownError 1
	_i19n_("Unknown error"),
	//#define KVI_ERROR_NoChildProcess 2
	_i19n_("No child process : not started or killed before completing operation"),
	//#define KVI_ERROR_NoHostToResolve 3
	_i19n_("No host to resolve"),
	//#define KVI_ERROR_HostNotFound 4
	_i19n_("Host not found"),
	//#define KVI_ERROR_ValidNameButNoIpAddress 5
	_i19n_("Valid name, but the host has no IP address"),
	//#define KVI_ERROR_UnrecoverableNameserverError 6
	_i19n_("Unrecoverable nameserver error"),
	//#define KVI_ERROR_DnsTemporaneousFault 7
	_i19n_("DNS temporaneous fault, try again"),
	//#define KVI_ERROR_DnsQueryFailed 8
	_i19n_("Dns query failed"),
	//#define KVI_ERROR_InvalidIpAddress 9
	_i19n_("Invalid IP address"),
	//#define KVI_ERROR_AnotherConnectionInProgress 10
	_i19n_("Another connection in progress"),
	//#define KVI_ERROR_SocketCreationFailed 11
	_i19n_("Socket creation failed"),
	//#define KVI_ERROR_AsyncSocketFailed 12
	_i19n_("Async socket operation not supported (fcntl failed)"),
	//#define KVI_ERROR_BadFileDescriptor 13
	_i19n_("Bad file descriptor"),
	//#define KVI_ERROR_OutOfAddressSpace 14
	_i19n_("Out of address space"),
	//#define KVI_ERROR_KernelNetworkingPanic 15
	_i19n_("Kernel networking panic"),
	//#define KVI_ERROR_ConnectionRefused 16
	_i19n_("Connection refused by remote host"),
	//#define KVI_ERROR_ConnectionTimedOut 17
	_i19n_("Connection attempt timed out"),
	//#define KVI_ERROR_NetworkUnreachable 18
	_i19n_("Network is unreachable"),
	//#define KVI_ERROR_RemoteEndClosedConnection 19
	_i19n_("Remote end closed connection"),
	//#define KVI_ERROR_NotConnectedToServer 20
	_i19n_("You're not connected to a server"),
	//#define KVI_ERROR_BrokenPipe 21
	_i19n_("Broken pipe"),
	//#define KVI_ERROR_NoServerEntries 22
	_i19n_("Cannot find a server to contact. Please select a server in the server options dialog."),
	//#define KVI_ERROR_GetsocknameFailed 23
	_i19n_("Unable to lookup local socket name."),
	//#define KVI_ERROR_InvalidProxyAddress 24
	_i19n_("Invalid proxy address."),
	//#define KVI_ERROR_UnrecognizedProxyReply 25
	_i19n_("Unrecognized proxy reply"),
	//#define KVI_ERROR_ProxyConnectionRejected 26
	_i19n_("Proxy connection rejected."),
	//#define KVI_ERROR_ProxyNoAcceptableMethods 27
	_i19n_("No acceptable authentication methods"),
	//#define KVI_ERROR_ProxyAuthFailed 28
	_i19n_("Proxy authorisation failed"),
	//#define KVI_ERROR_ProxyReply01GeneralSOCKSFailure 29
	_i19n_("Proxy error : General socks failure"),
	//#define KVI_ERROR_ProxyReply02ConnectionNotAllowed 30
	_i19n_("Proxy error : Connection not allowed"),
	//#define KVI_ERROR_ProxyReply03NetworkUnreachable 31
	_i19n_("Proxy error : Target network unreachable"),
	//#define KVI_ERROR_ProxyReply04HostUnreachable 32
	_i19n_("Proxy error : Target host unreachable"),
	//#define KVI_ERROR_ProxyReply05ConnectionRefused 33
	_i19n_("Proxy error : Target host refused the connection"),
	//#define KVI_ERROR_ProxyReply06TTLExpired 34
	_i19n_("Proxy error : Target connection failed : TTL Expired"),
	//#define KVI_ERROR_ProxyReply07CommandNotSupported 35
	_i19n_("Proxy error : Command nut supported"),
	//#define KVI_ERROR_ProxyReply08AddressTypeNotSupported 36
	_i19n_("Proxy error : Address type not supported"),
	//#define KVI_ERROR_ProxyReply09InvalidAddress 37
	_i19n_("Proxy error : Invalid address"),
	//#define KVI_ERROR_ProxyReply91RequestFailed 38
	_i19n_("Proxy error : 91 : Request failed"),
	//#define KVI_ERROR_ProxyReply92IdentFailed 39
	_i19n_("Proxy error : 92 : Ident failed"),
	//#define KVI_ERROR_ProxyReply93IdentNotMatching 40
	_i19n_("Proxy error : 93 : Ident not matching"),
	//#define KVI_ERROR_CompiledWithNoSound 41
	_i19n_("This executable was compiled without sound support"),
	//#define KVI_ERROR_SoundCardAlreadyOpen 42
	_i19n_("The soundcard device is already open"),
	//#define KVI_ERROR_CanNotOpenDevDsp 43
	_i19n_("Cpuld not open the soundcard device (/dev/dsp)"),
	//#define KVI_ERROR_CanNotInitializeSoundCard 44
	_i19n_("Could not initialize soundcard: unsupported format, channels number or sample rate"),
	//#define KVI_ERROR_MissingFileName 45
	_i19n_("Dummy : Missing file name"),
	//#define KVI_ERROR_MissingClosingBrace 46
	_i19n_("Missing closing brace"),
	//#define KVI_ERROR_UnknownCommand 47
	_i19n_("Unknown command"),
	//#define KVI_ERROR_MissingVariableName 48
	_i19n_("Missing variable name"),
	//#define KVI_ERROR_UnknownOperator 49
	_i19n_("Unknown operator"),
	//#define KVI_ERROR_UnknownIdentifier 50
	_i19n_("Unknown identifier"),
	//#define KVI_ERROR_UnknownFunction 51
	_i19n_("Unknown function"),
	//#define KVI_ERROR_UnexpectedEndOfCommand 52
	_i19n_("Unexpected end of command"),
	//#define KVI_ERROR_MissingOperator 53
	_i19n_("Missing operator"),
	//#define KVI_ERROR_MissingWindowName 54
	_i19n_("Missing window name"),
	//#define KVI_ERROR_WindowNotFound 55
	_i19n_("Window not found"),
	//#define KVI_ERROR_MissingIconNumber 56
	_i19n_("Missing icon number"),
	//#define KVI_ERROR_InvalidOption 57
	_i19n_("Invalid option/switch"),
	//#define KVI_ERROR_CantFindHelpFiles 58
	_i19n_("Cannot find external help data files, or cannot open it for reading.\n"\
		"Please check your installation"),
	//#define KVI_ERROR_NoHelpAvailable 59
	_i19n_("No help available on that...try /HELP index"),
	//#define KVI_ERROR_CantOpenFileForReading 60
	_i19n_("Could not open the file for reading"),
	//#define KVI_ERROR_LeftOperandIsNotANumber 61
	_i19n_("Left operand is not a numeric value"),
	//#define KVI_ERROR_RightOperandIsNotANumber 62
	_i19n_("Right operand is not a numeric value"),
	//#define KVI_ERROR_LeftOperandIsUndefined 63
	_i19n_("Left operand is undefined"),
	//#define KVI_ERROR_ParenthesisMismatch 64
	_i19n_("Unbalanced parenthesis"),
	//#define KVI_ERROR_UnexpectedCharacter 65
	_i19n_("Unexpected character"),
	//#define KVI_ERROR_InternalError 66
	_i19n_("OOOPS...Internal error ?"),
	//#define KVI_ERROR_MissingCommandAfterElse 67
	_i19n_("Missing command after else"),
	//#define KVI_ERROR_OpenParenthesisExpected 68
	_i19n_("Open parenthesis expected"),
	//#define KVI_ERROR_MissingCommandAfterWhile 69
	_i19n_("Missing command after while"),
	//#define KVI_ERROR_SingleStringOperand 70
	_i19n_("Single string operand"),
	//#define KVI_ERROR_OperandDoesNotMatchOperator 71
	_i19n_("Operand does not match operator"),
	//#define KVI_ERROR_DivisionByZero 72
	_i19n_("Division by zero"),
	//#define KVI_ERROR_UnexpectedEndInString 73
	_i19n_("Unexpected end in string"),
	//#define KVI_ERROR_DoWithoutWhile 74
	_i19n_("Do without while"),
	//#define KVI_ERROR_CommandTerminatorExpected 75
	_i19n_("Command terminator expected"),
	//#define KVI_ERROR_MissingDialogType 76
	_i19n_("Missing dialog type"),
	//#define KVI_ERROR_UnknownDialogType 77
	_i19n_("Unknown dialog type"),
	//#define KVI_ERROR_AliasNameExpected 78
	_i19n_("Alias name expected"),
	//#define KVI_ERROR_AliasBodyExpected 79
	_i19n_("Alias body expected"),
	//#define KVI_ERROR_MissingChannelName 80
	_i19n_("Missing channel name"),
	//#define KVI_ERROR_ModeRequiresParameters 81
	_i19n_("Mode requires parameters"),
	//#define KVI_ERROR_OpenBraceExpected 82
	_i19n_("Open brace '{' expected"),
	//#define KVI_ERROR_CaseDefaultMatchOrEndOfSwitchExpected 83
	_i19n_("Case, match, default command or end of switch expected"),
	//#define KVI_ERROR_CommandExpectedAfterDefault 84
	_i19n_("Command expected after 'default'"),
	//#define KVI_ERROR_CommandExpectedAfterCase 85
	_i19n_("Command expected after 'case()'"),
	//#define KVI_ERROR_EndOfSwitchExpectedAfterDefault 86
	_i19n_("End of switch expected after 'default' action"),
	//#define KVI_ERROR_CommandExpectedAfterMatch 87
	_i19n_("Command expected after 'match()'"),
	//#define KVI_ERROR_NickRequiresANick 88
	_i19n_("NICK requires a nickname!"),
	//#define KVI_ERROR_PopupItemCommandExpected 89
	_i19n_("Popup menu item command definition expected"),
	//#define KVI_ERROR_ItemPopupOrSeparatorExpected 90
	_i19n_("Item, popup or separator expected"),
	//#define KVI_ERROR_UnknownPopup 91
	_i19n_("Unknown popup"),
	//#define KVI_ERROR_MissingParameter 92
//	_i19n_("Missing parameter"),
	//#define KVI_ERROR_ThisIsNotAChannel 92
	_i19n_("This is not a channel"),
	//#define KVI_ERROR_MissingTarget 93
	_i19n_("Missing target"),
//	#define KVI_ERROR_WhoQueriesRequireANick 94
	_i19n_("Who queries require nickname parameters"),
//	#define KVI_ERROR_MissingCtcpType 95
	_i19n_("Missing CTCP type"),
//	#define KVI_ERROR_ThisIsNotAQueryNorChannel 96
	_i19n_("This is not a query/channel"),
//	#define KVI_ERROR_LogOnOffRequired 97
	_i19n_("Log on/off required"),
//	#define KVI_ERROR_CantStartLoggingInThisWindow 98
	_i19n_("Could not start logging in this window"),
//	#define KVI_ERROR_CantStartLogging 99
	_i19n_("Could not start logging."),
//	#define KVI_ERROR_CanNotStartDnsThread 100
	_i19n_("Could not start the DNS thread."),
//	#define KVI_ERROR_UnsupportedDccType 101
	_i19n_("Unsupported DCC type"),
//	#define KVI_ERROR_MissingMask 102
	_i19n_("Missing user mask"),
//	#define KVI_ERROR_AlreadyRegistered 103
	_i19n_("User already registered"),
//	#define KVI_ERROR_InvalidRegistrationMask 104
	_i19n_("Invalid registration mask : must be of type nick!user@host and can contain the '*' wildcard"),
//	#define KVI_ERROR_RegistrationWillBeResetByDialog 105
	_i19n_("The registration dialog is open, please add/remove the user from that dialog, or close it before using this command"),
//	#define KVI_ERROR_UserNotRegistered 106
	_i19n_("User not registered"),
//	#define KVI_ERROR_AliasSelfModificationNotAllowed 107
	_i19n_("Cannot self-modify the alias while executing it"),
//	#define KVI_ERROR_PopupSelfModificationNotAllowed 108
	_i19n_("Cannot self-modify the popup while executing it"),
//	#define KVI_ERROR_NotAValidScriptFile 109
	_i19n_("The file is not a valid KVIrc script"),
//	#define KVI_ERROR_StringLengthExpected 110
	_i19n_("Invalid parameter, string length expected"),
//	#define KVI_ERROR_StringIndexExpected 110
	_i19n_("Invalid parameter, string index expected"),
//	#define KVI_ERROR_MissingTimeout 112
	_i19n_("Missing timeout"),
//	#define KVI_ERROR_NoMimeTypeMatching 113
	_i19n_("No mime type matching"),
//	#define KVI_ERROR_NoCommandlineForMimeType 114
	_i19n_("No commandline specified for mimetype"),
//	#define KVI_ERROR_MissingTimerName 115
	_i19n_("Missing timer name"),
//	#define KVI_ERROR_InvalidTimeout 116	
	_i19n_("Invalid timeout"),
//	#define KVI_ERROR_InvalidPort 117
	_i19n_("Invalid port"),
//	#define KVI_ERROR_NoMatchingTimers 118
	_i19n_("No matching timers"),
//	#define KVI_ERROR_MissingOptionName		119
	_i19n_("Missing option name"),
//	#define KVI_ERROR_NoSuchOption			120
	_i19n_("No such option"),
//	#define KVI_ERROR_MissingOptionValue	121
	_i19n_("Missing option value"),
//	#define KVI_ERROR_InvalidOptionType		122
	_i19n_("Invalid option type"),
//	#define KVI_ERROR_NoAliasWithThatName   123
	_i19n_("No alias with that name"),
//	#define KVI_ERROR_InvalidRangeValue 124
	_i19n_("Invalid range value"),
//	#define KVI_ERROR_MissingCommandline 125
	_i19n_("Missing commandline"),
//	#define KVI_ERROR_ProcessStartFailed 126
	_i19n_("Process start failed"),
//	#define KVI_ERROR_MissingWindowOperation 127
	_i19n_("Missing window operation"),
//	#define KVI_ERROR_UnknownWindowOperation 128
	_i19n_("Unknown window operation"),
//	#define KVI_ERROR_ThisWindowHasNoTextBuffer 129
	_i19n_("This window has not text buffer"),
//	#define KVI_ERROR_WindowPositionXYExpected 130
	_i19n_("Window position X,Y Expected"),
//	#define KVI_ERROR_WindowSizeExpected 131
	_i19n_("Window size expected"),
//	#define KVI_ERROR_UnknownImageFormat 132
	_i19n_("Unknown image format"),
//	#define KVI_ERROR_UnableToSaveBuffer 133
	_i19n_("Unable to save text buffer"),
//	#define KVI_ERROR_MissingNickname 134
	_i19n_("Missing nickname"),
//	#define KVI_ERROR_UnsignedIntegerExpected 135
	_i19n_("Unsigned integer expected"),
//	#define KVI_ERROR_ConfigFilePathExpected 136
	_i19n_("Config file path expected"),
//	#define KVI_ERROR_InvalidConfigType 137
	_i19n_("Invalid config type"),
//	#define KVI_ERROR_ThisWindowHasNoCommandline 138
	_i19n_("This window has not commandline input"),
//	#define KVI_ERROR_MissingPitch 139
	_i19n_("Missing pitch"),
//	#define KVI_ERROR_MissingDuration 140
	_i19n_("Missing duration"),
//	#define KVI_ERROR_ChannelNotFound 141
	_i19n_("Channel not found"),
//	#define KVI_ERROR_MissingDirName 142
	_i19n_("Missing directory name"),
//	#define KVI_ERROR_CantListDirContents 143
	_i19n_("Unable to list directory contents"),
//	#define KVI_ERROR_InvalidDirectory 144
	_i19n_("Invalid directory"),
//	#define KVI_ERROR_CantCDInThatDirectory 145
	_i19n_("Cannot CD to that directory"),
//	#define KVI_ERROR_MissingPid 146
	_i19n_("Missing pid"),
//	#define KVI_ERROR_NoSuchProcess 147
	_i19n_("No such process"),
//	#define KVI_ERROR_CantWriteToProcess 148
	_i19n_("Could not write to process"),
//	#define KVI_ERROR_InvalidWindowName 149
	_i19n_("Invalid window name. You forgot the *."),
//	#define KVI_ERROR_MissingDictionaryKey 150
	_i19n_("Missing dictionary key"),
//	#define KVI_ERROR_MissingDictionaryName 151
	_i19n_("Missing dictionary name"),
//	#define KVI_ERROR_PluginFilePathExpected 152
	_i19n_("Plugin file path expected"),
//	#define KVI_ERROR_InvalidPluginOperation 153
	_i19n_("Invalid plugin operation"),
//	#define KVI_ERROR_NoPluginSupport 154
	_i19n_("No plugin support in this executable"),
//	#define KVI_ERROR_NoSuchPlugin 155
	_i19n_("No such plugin"),
//	#define KVI_ERROR_CantLoadPlugin 156
	_i19n_("Unable to load plugin"),
//	#define KVI_ERROR_CantExecutePluginInitRoutine 157
	_i19n_("Could not execute plugin init routine"),
//	#define KVI_ERROR_MissingParameter 158
	_i19n_("Missing parameter"),
//	#define KVI_ERROR_InvalidParameter 159
	_i19n_("Invalid parameter"),
//	#define KVI_ERROR_InvalidOperation 160
	_i19n_("Invalid operation"),
//	#define KVI_ERROR_MissingKey 161
	_i19n_("Missing key"),
//	#define KVI_ERROR_MissingSection 162
	_i19n_("Missing section"),
//	#define KVI_ERROR_UtoolbarCommandExpected 163
	_i19n_("Utoolbar command expected: button, separator, menu, update, clear"),
//	#define KVI_ERROR_MissingCommandBlockToTry 164
	_i19n_("Missing command block to try"),
//	#define KVI_ERROR_CantOpenFileForWriting 165
	_i19n_("Could not open the file for writing"),
//	#define KVI_ERROR_MissingObjectClass 166
	_i19n_("Missing object class"),
//	#define KVI_ERROR_MissingObjectName 167
	_i19n_("Missing object name"),
//	#define KVI_ERROR_MissingObjectParent 168
	_i19n_("Missing object parent"),
//	#define KVI_ERROR_UnknownObjectClass 169
	_i19n_("Unknown object class"),
//	#define KVI_ERROR_InexistingParentObject 170
	_i19n_("Inexisting parent object"),
//	#define KVI_ERROR_ObjectNotFound 171
	_i19n_("Object not found"),
//	#define KVI_ERROR_MissingObjectField 172
	_i19n_("Missing object field name"),
//	#define KVI_ERROR_MissingObjectId 173
	_i19n_("Missing object ID"),
//	#define KVI_ERROR_MissingObjectEventName 174
	_i19n_("Missing object event name"),
//	#define KVI_ERROR_NoSuchObjectFunction 175
	_i19n_("No such object function"),
//	#define KVI_ERROR_ObjectFunctionFailure 176
	_i19n_("Object function call failure"),
//	#define KVI_ERROR_ClassAlreadyDefined 177
	_i19n_("Class already defined"),
//	#define KVI_ERROR_EventOrFunctionKeywordExpected 178
	_i19n_("Event or Function keyword expected"),
//	#define KVI_ERROR_InvalidClassOverride 179
	_i19n_("Invalid class override"),
//	#define KVI_ERROR_VariableOrIdentifierExpected 180
	_i19n_("Variable or identifier expected"),
//	#define KVI_ERROR_NotConnected 181
	_i19n_("Not connected"),
//	#define KVI_ERROR_ObjectIsNotASocket 182
	_i19n_("The object is not a socket"),
//	#define KVI_ERROR_NoConnectionToAccept 183
	_i19n_("The socket object has no connections to accept"),
//	#define KVI_ERROR_NoTextToFind 184
	_i19n_("No text to find"),
//	#define KVI_ERROR_NoSuchQtProperty 185
	_i19n_("No such Qt property"),
//	#define KVI_ERROR_ObjectIsNotAWidget 186
	_i19n_("The object is not a widget"),
//	#define KVI_ERROR_MissingSignalName 187
	_i19n_("Missing signal name"),
//	#define KVI_ERROR_MissingSlotName 188
	_i19n_("Missing slot name"),
//	#define KVI_ERROR_UnsupportedQtProperty 189
	_i19n_("Unsupported Qt property"),
//	#define KVI_ERROR_MissingUrl 190
	_i19n_("Missing URL"),
//	#define KVI_ERROR_MissingBrowserCommandlineOption 191
	_i19n_("Missing browser commandline : set it in the misc options dialog!"),
//	#define KVI_ERROR_ObjectIsNotAPopup 192
	_i19n_("Object is not a popup menu"),
//	#define KVI_ERROR_MissingHostname 193
	_i19n_("Missing hostname"),
//	#define KVI_ERROR_MissingServicesCommand 194
	_i19n_("Missing services command"),
//	#define KVI_ERROR_UserhostRequiresANick 195
	_i19n_("Userhost queries require nickname parameters"),
//	#define KVI_ERROR_UserRequiresUHS 196
	_i19n_("User command requires username, host, server, and optionally, description"),
	//end
	0
};

const char * kvi_getErrorString(int errorNum)
{
	__range_valid(errorNum < KVI_ERROR_NUMBER_OF_ERRORS);
	if(errorNum < 0){
		//Unhandled system errors (errno value not handled in switches)
#ifdef HAVE_STRERROR
		__debug_1arg("Negative error for us...Strerr error %s",strerror(errorNum));
		return strerror(-errorNum);
#else
		__debug_1arg("Have no strerror, errorNum was %d",-errorNum);
		errorNum = KVI_ERROR_UnknownError;
#endif
	}
	return _i18n_translateNoText(g_kviErrorStringTable[errorNum]);
}
