//
//   File : kvi_dlgloadscript.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dlgloadscript.cpp)
//   Last major modification : Thu Jun 24 1999 17:51:07 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_dlgloadscript.h"
#include "kvi_locale.h"
#include "kvi_app.h"
#include "kvi_fileutils.h"
#include "kvi_config.h"
#include "kvi_defines.h"
#include <qlayout.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <qsplitter.h>

/*
	TODO : whatIsThis doesn't work here!
*/

KviDlgLoadScript::KviDlgLoadScript(QWidget *parent)
:QDialog(parent,"dlgloadscript")
{
	setCaption(__tr("KVIrc: Load Script"));

	QSplitter *s = new QSplitter(this);

	QGridLayout * g1 = new QGridLayout(this,6,3,10,4);

	KviStr szPath;
	g_pApp->getLocalKVircDirectory(szPath,KviApp::Scripts);
	szPath.prepend(__tr("Script directory: "));
	QLabel *l = new QLabel(szPath.ptr(),this);
	g1->addMultiCellWidget(l,0,0,0,2);

	g1->addMultiCellWidget(s,1,1,0,2);

	l = new QLabel(__tr("Before loading a new script, clear existing:"),this);
	g1->addMultiCellWidget(l,2,2,0,2);

	m_pRemoveEventsCheck = new QCheckBox(__tr("Events"),this);
	m_pRemoveEventsCheck->setChecked(true); // default
	g1->addWidget(m_pRemoveEventsCheck,3,0);

	m_pRemoveAliasesCheck = new QCheckBox(__tr("Aliases"),this);
	g1->addWidget(m_pRemoveAliasesCheck,3,1);

	m_pRemovePopupsCheck = new QCheckBox(__tr("Popups"),this);
	m_pRemovePopupsCheck->setChecked(true); // default
	g1->addWidget(m_pRemovePopupsCheck,3,2);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g1->addMultiCellWidget(f,4,4,0,2);

	QPushButton *btn = new QPushButton(__tr("What's &This?"),this);
	btn->setEnabled(false);
//#warning "What is this ? button !"
	g1->addWidget(btn,5,0);

	m_pOkButton = new QPushButton(__tr("&Install"),this);
	connect(m_pOkButton,SIGNAL(clicked()),this,SLOT(okPressed()));
	m_pOkButton->setDefault(true);
	g1->addWidget(m_pOkButton,5,1);
	m_pOkButton->setEnabled(false);

	btn = new QPushButton(__tr("&Cancel"),this);
	connect(btn,SIGNAL(clicked()),this,SLOT(cancelPressed()));
	g1->addWidget(btn,5,2);

	g1->setRowStretch(0,1);

	m_pListBox = new QListBox(s);
	connect(m_pListBox,SIGNAL(highlighted(int)),this,SLOT(scriptSelected(int)));
	m_pListBox->setMinimumWidth(100);

	QWidget * base = new QWidget(s);

	QGridLayout * g = new QGridLayout(base,11,2,0,2);

	l = new QLabel(__tr("Name:"),base);
	l->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	l->setEnabled(false);
	g->addWidget(l,0,0);
	m_pScriptName = new QLabel(base);
	m_pScriptName->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pScriptName,0,1);

	l = new QLabel(__tr("Version:"),base);
	l->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	l->setEnabled(false);
	g->addWidget(l,1,0);
	m_pScriptVersion = new QLabel(base);
	m_pScriptVersion->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pScriptVersion,1,1);

	l = new QLabel(__tr("Author:"),base);
	l->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	l->setEnabled(false);
	g->addWidget(l,2,0);
	m_pScriptAuthor = new QLabel(base);
	m_pScriptAuthor->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pScriptAuthor,2,1);

	l = new QLabel(__tr("E-Mail:"),base);
	l->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	l->setEnabled(false);
	g->addWidget(l,3,0);
	m_pScriptEMail = new QLabel(base);
	m_pScriptEMail->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pScriptEMail,3,1);

	l = new QLabel(__tr("Date:"),base);
	l->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	l->setEnabled(false);
	g->addWidget(l,4,0);
	m_pScriptDate = new QLabel(base);
	m_pScriptDate->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pScriptDate,4,1);

	l = new QLabel(__tr("Generator:"),base);
	l->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	l->setEnabled(false);
	g->addWidget(l,5,0);
	m_pScriptGenerator = new QLabel(base);
	m_pScriptGenerator->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pScriptGenerator,5,1);

	l = new QLabel(__tr("Language Tag:"),base);
	l->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	l->setEnabled(false);
	g->addWidget(l,6,0);
	m_pScriptLanguageTag = new QLabel(base);
	m_pScriptLanguageTag->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pScriptLanguageTag,6,1);

	l = new QLabel(__tr("Description:"),base);
	l->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	l->setEnabled(false);
	g->addMultiCellWidget(l,7,7,0,1);
	m_pScriptDescription = new QMultiLineEdit(base);
	m_pScriptDescription->setReadOnly(true);
	g->addMultiCellWidget(m_pScriptDescription,8,8,0,1);

	l = new QLabel(__tr("Warnings:"),base);
	l->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	l->setEnabled(false);
	g->addMultiCellWidget(l,9,9,0,1);
	m_pScriptWarnings = new QMultiLineEdit(base);
	m_pScriptWarnings->setReadOnly(true);
	g->addMultiCellWidget(m_pScriptWarnings,10,10,0,1);

	g->setColStretch(1,1);
	g->setRowStretch(8,1);
	g->setRowStretch(10,1);

	m_pScriptList = new QList<KviScriptDefinition>;
	m_pScriptList->setAutoDelete(true);

	scanScriptDirectory();
	if(m_pScriptList->count() > 0){
		m_pListBox->setCurrentItem(0);
		scriptSelected(0);
	} else m_pOkButton->setEnabled(false);

}

KviDlgLoadScript::~KviDlgLoadScript()
{
	delete m_pScriptList;
}

void KviDlgLoadScript::scanScriptDirectory()
{
	KviStr dir;
	g_pApp->getLocalKVircDirectory(dir,KviApp::Scripts);
	QDir d(dir.ptr());

	const QFileInfoList * fi = d.entryInfoList();
	if(!fi)return;

	QFileInfoListIterator it(*fi);
	QFileInfo *i;

	while((i = it.current())){
		++it;
		if(i->isDir()){
			KviStr dirName = i->fileName();
			g_pApp->getLocalKVircDirectory(dir,KviApp::Scripts,dirName.ptr());
			KviStr kvsName(KviStr::Format,"%s/main.kvs",dir.ptr());
			if(!kvi_fileExists(kvsName.ptr()))continue;

			KviScriptDefinition * def = new KviScriptDefinition;
			def->szKvsFileName = kvsName;

			KviStr defName(KviStr::Format,"%s/script.def",dir.ptr());
			if(kvi_fileExists(defName.ptr())){
				KviConfig cfg(defName.ptr());
				cfg.setGroup("KVIrc_Script_Definition");
				def->szAuthor      = cfg.readEntry("AUTHOR");
				def->szEMail       = cfg.readEntry("EMAIL");
				def->szVersion     = cfg.readEntry("VERSION");
				def->szGenerator   = cfg.readEntry("GENERATOR");
				def->szName        = cfg.readEntry("NAME");
				def->szDate        = cfg.readEntry("DATE");
				def->szLanguageTag = cfg.readEntry("LANGUAGETAG");
			} else {
				def->szWarnings.append(__tr("The script definition file (dcript.def) is missing.\n"));
			}
			KviStr desName(KviStr::Format,"%s/script.des",dir.ptr());
			if(kvi_fileExists(desName.ptr())){
				kvi_loadFile(desName.ptr(),def->szDescription);
				def->szDescription.stripWhiteSpace();
				if(def->szDescription.isEmpty())def->szWarnings.append(__tr("The script description file is empty.\n"));
			} else {
				def->szWarnings.append(__tr("The script description file (script.des) is missing.\n"));
			}
			if(def->szName.isEmpty()){
				def->szWarnings.append(__tr("The script has no name.\n"));
				def->szName.sprintf("%s/main.kvs",dirName.ptr());
			}
			if(def->szVersion.isEmpty())def->szWarnings.append(__tr("The script version is not specified.\n"));
			if(def->szAuthor.isEmpty())def->szWarnings.append(__tr("The script author is unknown.\n"));
			if(def->szEMail.isEmpty())def->szWarnings.append(__tr("There is no author e-mail.\n"));
			if(def->szGenerator.isEmpty())def->szWarnings.append(__tr("No script generator is specified (handmade script ?).\n"));
			if(def->szLanguageTag.isEmpty() || (!def->szLanguageTag.isUnsignedNum()))def->szWarnings.append(__tr("Can not determine the scripting language version used.\n"));
			else {
				unsigned int lTag = def->szLanguageTag.toUInt();
				if(lTag > KVI_NUMERIC_SCRIPT_LANGUAGE_TAG){
					def->szWarnings.append(__tr("The script language version is higher than the one supported by this copy of KVIrc.\nThe script may not work correctly.\n"));
				}
			}
			m_pScriptList->append(def);
			m_pListBox->insertItem(def->szName.ptr());
		}
	}
}

void KviDlgLoadScript::okPressed()
{
	emit finished(true);
}

void KviDlgLoadScript::cancelPressed()
{
	emit finished(false);
}

void KviDlgLoadScript::scriptSelected(int idx)
{
	if((idx < 0) || (((uint)idx) >= m_pScriptList->count())){
		m_pOkButton->setEnabled(false);
		m_pScriptName->setText("");
		m_pScriptVersion->setText("");
		m_pScriptAuthor->setText("");
		m_pScriptEMail->setText("");
		m_pScriptGenerator->setText("");
		m_pScriptLanguageTag->setText("");
		m_pScriptDescription->setText("");
		m_pScriptDate->setText("");
		m_pScriptWarnings->setText("");
		return;
	}
	KviScriptDefinition *d = m_pScriptList->at(idx);
	if(!d)return; //failsafe

	m_pOkButton->setEnabled(true);

	m_pScriptName->setText(d->szName.ptr());
	m_pScriptVersion->setText(d->szVersion.ptr());
	m_pScriptAuthor->setText(d->szAuthor.ptr());
	m_pScriptEMail->setText(d->szEMail.ptr());
	m_pScriptDate->setText(d->szDate.ptr());
	m_pScriptGenerator->setText(d->szGenerator.ptr());
	m_pScriptLanguageTag->setText(d->szLanguageTag.ptr());
	m_pScriptDescription->setText(d->szDescription.ptr());
	m_pScriptWarnings->setText(d->szWarnings.ptr());
}

void KviDlgLoadScript::getSelectedScriptFileName(KviStr &buffer,bool &bRemoveAliases,bool &bRemovePopups,bool &bRemoveEvents)
{
	int idx = m_pListBox->currentItem();
	if(idx < 0) return;
	if(((unsigned int)idx) >= m_pScriptList->count())return;
	KviScriptDefinition *d = m_pScriptList->at(idx);
	if(!d)return;
	buffer = d->szKvsFileName;
	bRemoveAliases = m_pRemoveAliasesCheck->isChecked();
	bRemovePopups = m_pRemovePopupsCheck->isChecked();
	bRemoveEvents = m_pRemoveEventsCheck->isChecked();
}

void KviDlgLoadScript::closeEvent(QCloseEvent *)
{
	emit finished(false);
}

#include "m_kvi_dlgloadscript.moc"
