/***************************************************************************
             kvi_dlgfind.cpp  -  KviWindow "Find Text" Dialog
                             -------------------
    begin                : Fri Aug 3 2001
    copyright            : (C) 2001 by Triskelios
    email                : trisk@quasarnet.org
 ***************************************************************************

     This file is part of the KVIrc IRC client distribution
     Copyright (C) 1999-2001 Szymon Stefanek (stefanek@tin.it)
     Copyright (C) 2001 Triskelios (trisk@quasarnet.org)

 ***************************************************************************

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 ***************************************************************************/

#include "kvi_dlgfind.h"
#include "kvi_ircview.h"
#include "kvi_window.h"
#include "kvi_locale.h"

#include <qdialog.h>
#include <qlayout.h>
#include <qframe.h>
//#include <qclipboard.h>
#include <qlabel.h>
#include <qpushbutton.h>

KviFindDialog::KviFindDialog(QWidget * parent)
:QDialog(parent,"dlgfind",true)
{
	setCaption(__tr("Find Text"));
//	m_pWin=kcmd->window;
	m_pWin = (KviWindow *)parent;
	QGridLayout *g = new QGridLayout(this,5,2,10,4);

	QLabel *l = new QLabel(__tr("Text to find:"),this);
	g->addMultiCellWidget(l,0,0,0,1);

//	QClipboard *cb = QApplication::clipboard();
	m_pTextField = new QComboBox(true,this);
//	m_pTextField->setEditText(cb->text());
	m_pTextField->setMaxCount(10);
	m_pTextField->setInsertionPolicy(QComboBox::AtTop);
	m_pTextField->setAutoCompletion(true);
	m_pTextField->setDuplicatesEnabled(false);
	g->addMultiCellWidget(m_pTextField,1,1,0,1);

	m_pCheckBox = new QCheckBox(__tr("Find backwards"),this);
	g->addMultiCellWidget(m_pCheckBox,2,2,0,1);

	QFrame *r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(r,3,3,0,1);

	QPushButton *b = new QPushButton(__tr("&Find"),this);
	b->setDefault(true);
	connect(b,SIGNAL(clicked()),this,SLOT(findText()));
	g->addWidget(b,4,0);

	b = new QPushButton(__tr("&Close"),this);
	connect(b,SIGNAL(clicked()),this,SLOT(reject()));
	g->addWidget(b,4,1);
}

void KviFindDialog::findText()
{
	if(!m_pCheckBox->isChecked())
		m_pWin->m_pView->findNext(m_pTextField->currentText().ascii());
	else m_pWin->m_pView->findPrev(m_pTextField->currentText().ascii());
	if(m_pTextField->text(m_pTextField->currentItem()) != m_pTextField->currentText())
		if(!m_pTextField->currentText().isNull() && !m_pTextField->currentText().isEmpty())
			m_pTextField->insertItem(m_pTextField->currentText(),0);
}

//void KviFindDialog::cancel()
//{
//
//}


KviFindDialog::~KviFindDialog()
{
}

#include "m_kvi_dlgfind.moc"