//
//   File : kvi_console.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_console.cpp)
//   Last major modification : Tue Jul 6 1999 14:36:15 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_console.h"
#include "kvi_app.h"
#include "kvi_ircview.h"
#include "kvi_input.h"
#include "kvi_frame.h"
#include "kvi_listbox.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_popupmenu.h"
#include "kvi_uparser.h"
#include "kvi_mdi.h"

#include <qvaluelist.h>
#include <qtooltip.h>

//Declared in kvi_app.cpp and managed by KviApp class
//extern QPixmap * g_pWindowIcon[KVI_WND_NUM_ICONS];
extern QPixmap * g_pixViewOut[KVI_OUT_NUM_IMAGES];
extern KviPopupMenu *g_pConsolePopup;
extern KviPopupMenu *g_pNotifylistPopup;

//============ KviConsole ============//

KviConsole::KviConsole(KviFrame *lpFrm)
:KviWindow(KVI_CONSOLE_WINDOW_NAME,KVI_WND_TYPE_CONSOLE,lpFrm)
{
	m_pSplitter  = new QSplitter(QSplitter::Horizontal,this,"console_splitter");
	m_pView      = new KviIrcView(m_pSplitter,lpFrm,this);
	m_pListBox   = new KviListBox(m_pSplitter,this,lpFrm->m_pUserParser,lpFrm);
	m_pInput     = new KviInput(this,lpFrm->m_pUserParser,m_pListBox);

	connect(m_pView,SIGNAL(contextPopupRequested(KviIrcView *)),this,SLOT(viewRightClicked(KviIrcView *)));
	connect(m_pListBox,SIGNAL(rightClicked()),this,SLOT(listBoxRightClicked()));

	QToolTip::add(m_pListBox,__tr("Notify list"));

	setFocusHandler(m_pInput);
}

//============ ~KviConsole ============//

KviConsole::~KviConsole()
{

}

void KviConsole::saveProperties()
{
	KviWindowProperty p;
	p.rect = externalGeometry();
	p.isDocked = isAttached();
	QValueList<int> l(m_pSplitter->sizes());
	if(l.count() >= 1)p.splitWidth1 = *(l.at(0));
	if(l.count() >= 2)p.splitWidth2 = *(l.at(1));
	p.timestamp = m_pView->timestamp();
	p.imagesVisible = m_pView->imagesVisible();
//	debug("t = %d , i = %d",m_pView->timestamp(),m_pView->imagesVisible());
	KviWindow * w = m_pFrm->activeWindow();
	p.isMaximized = isAttached() && w ? w->isMaximized() : isMaximized();
	p.topSplitWidth1 = 0;
	p.topSplitWidth2 = 0;
	p.topSplitWidth3 = 0;
	g_pOptions->m_pWinPropertiesList->setProperty(caption(),&p);
}

void KviConsole::setProperties(KviWindowProperty *p)
{
	QValueList<int> l;
	l.append(p->splitWidth1);
	l.append(p->splitWidth2);
	m_pSplitter->setSizes(l);
	m_pView->setTimestamp(p->timestamp);
	m_pView->setShowImages(p->imagesVisible);
}

void KviConsole::viewRightClicked(KviIrcView *)
{
	g_pConsolePopup->doPopup(this,SLOT(viewPopupClicked(const KviStr &)));
}

void KviConsole::viewPopupClicked(const KviStr &dataBuffer)
{
	m_pFrm->m_pUserParser->parseCommand(dataBuffer.ptr(),this);
}

void KviConsole::listBoxRightClicked()
{
	g_pNotifylistPopup->doPopup(this,SLOT(notifylistPopupClicked(const KviStr &)));
}

void KviConsole::notifylistPopupClicked(const KviStr &dataBuffer)
{
//	debug("Userlist popup clicked : %s : channel %s",dataBuffer.ptr(),caption());
	m_pFrm->m_pUserParser->parseCommand(dataBuffer.ptr(),this);
}

//================ myIconPtr =================//

QPixmap * KviConsole::myIconPtr()
{
	return g_pixViewOut[KVI_OUT_WND_CONSOLE];
}

//=============== applyOptions ================//

void KviConsole::applyOptions()
{
	m_pView->setFont(g_pOptions->m_fntView);
	m_pView->setShowImages(g_pOptions->m_bShowImages,false);
	m_pView->setTimestamp(g_pOptions->m_bTimestamp);
	m_pView->setMaxBufferSize(g_pOptions->m_iViewMaxBufferSize);
}

//================ resizeEvent ===============//

void KviConsole::resizeEvent(QResizeEvent *)
{
	int inputSize = m_pInput->heightHint();
	m_pSplitter->setGeometry(0,0,width(),height() - inputSize);
	m_pInput->setGeometry(0,height() - inputSize,width(),inputSize);
}

void KviConsole::youAreAttached(KviMdiChild *lpC)
{
	KviWindow::youAreAttached(lpC);
	lpC->enableClose(false);
}


#include "m_kvi_console.moc"
