#ifndef _KVI_CHANNEL_H_INCLUDED_
#define _KVI_CHANNEL_H_INCLUDED_

//
//   File : kvi_channel.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_channel.h)
//   Last major modification : Sat Apr 3 1999 17:17:46 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include "kvi_ircuser.h"
#include "kvi_string.h"
#include "kvi_opaquelabel.h"

#include <qlist.h>
#include <qlabel.h>
#include <qdatetime.h>
#include <qpopupmenu.h>

typedef struct KviBanMask{
	KviStr mask;
	KviStr setBy;
	KviStr setAt;
};


class KviModeEditor;
class KviTopicEditor;
class KviMaskEditor;
class KviIrcUserChanList;

class KviNewTopicEditor;


#define KVI_CHANSYNC_NOTINSYNC 0
#define KVI_CHANSYNC_HAVENAMES 1
#define KVI_CHANSYNC_HAVETOPIC 2
#define KVI_CHANSYNC_HAVEMODE  4
#define KVI_CHANSYNC_HAVEWHO   8
#define KVI_CHANSYNC_HAVEBANS  16

#define KVI_MASKEDIT_BANS 0
#define KVI_MASKEDIT_BANEXCEPTIONS 1
#define KVI_MASKEDIT_INVITEEXCEPTIONS 2

class KviChannel : public KviWindow
{
	friend class KviHelpWindow; //It uses our output widget
	friend class KviServerParser; //Uses the ListBox to update users.
	Q_OBJECT
public:		// Consruction & Destruction
	KviChannel(KviFrame *lpFrm,const char *name);
	~KviChannel();
public:		// Fields
	QSplitter         * m_pTopSplitter;
	KviChanLabel      * m_pTopicLabel;
	KviChanLabel      * m_pModeLabel;
	KviChanLabel      * m_pUsersLabel;
	QList<KviBanMask> * m_pBanList;
	QList<KviBanMask> * m_pExceptionList;
	QList<KviBanMask> * m_pInviteExceptionList;
	QPopupMenu        * m_pMasksEditPopup;
	int                 m_iBanCount;
	int                 m_iExceptionCount;
	int                 m_iInviteExceptionCount;
	KviModeEditor     * m_pModeEditor;
	KviTopicEditor    * m_pTopicEditor;
//	KviMaskEditor     * m_pMaskEditor;
	KviMaskEditor     * m_pBanEditor;
	KviMaskEditor     * m_pBanExceptEditor;
	KviMaskEditor     * m_pInviteExceptEditor;
	bool                m_bTopicChangeEnabled;
	bool                m_bModeChangeEnabled;
	bool                m_bOnChannel;
	QTime               m_joinTime;
	int                 m_iChanSyncMask;
	int                 m_iLastMasksEdited;

	KviStr              m_szChanMode;
	KviStr              m_szUsersLimit;
	KviStr              m_szChanKey;

public:		// Methods
	void setTopicChangeEnabled(bool bEnabled);
	void setModeChangeEnabled(bool bEnabled);
	bool isMeOwner();
	bool isMeOp();
	bool isMeHalfOp();
	bool isMeVoice();
	bool isMeUserOp();
	bool isModeActive(char modeFlag);
	void setModeFlag(char modeFlag,bool bSet=true,const char * param = 0);
	void unsetModeFlag(char modeFlag){ setModeFlag(modeFlag,false); };
	void join(const KviIrcUser &user,char bOp=0,char bVoice=0,char bHalfOp=0,char bUserOp=0,char bOwner=0,bool bRepaint=true);
	void join(const char *nick,char bOp=0,char bVoice=0,char bHalfOp=0,char bUserOp=0,char bOwner=0,bool bRepaint=true);
	void part(const char *nick);
	void part(const KviIrcUser &user);
	bool nickChange(const KviIrcUser &nicker,const char *newNick); //Returns true if the nick was on channel!
	void banMask(const char *banMask,const char *setBy,const char *setAt,bool bAdd);
	void banExceptionMask(const char *banExcMask,const char *setBy,const char *setAt,bool bAdd);
	void inviteExceptionMask(const char *inviteExcMask,const char *setBy,const char *setAt,bool bAdd);
	bool isOnChannel(const KviIrcUser &user);
	bool isOnChannel(const char *nick);
	bool owner(const char *nick,bool bOwner=true);
	bool owner(const KviIrcUser &user,bool bOwner=true);
	bool op(const char *nick,bool bOp=true);
	bool op(const KviIrcUser &user,bool bOp=true);
	bool halfop(const char *nick,bool bHalfOp=true);
	bool halfop(const KviIrcUser &user,bool bHalfOp=true);
	bool voice(const char *nick,bool bVoice=true);
	bool voice(const KviIrcUser &user,bool bVoice=true);
	bool userop(const char *nick,bool bUserOp=true);
	bool userop(const KviIrcUser &user,bool bUserOp=true);
	bool isOwner(const char *nick);
	bool isOp(const char *nick);
	bool isHalfOp(const char *nick);
	bool isVoice(const char *nick);
	bool isUserOp(const char *nick);
	void setTopic(const char *text);
	void appendTopic(KviStr &buffer);
	void updateUsersLabel();
	void repaintListBox();
	void endOfNamesList();
	void endOfWho();
	void gotModeReply();
	void gotTopicReply();
	void gotBanlistReply();
	void checkSyncComplete();
	bool hasAllNames(){ return (m_iChanSyncMask & KVI_CHANSYNC_HAVENAMES); };
	bool whoRequestDone(){ return (m_iChanSyncMask & KVI_CHANSYNC_HAVEWHO); };
	bool kickDumpChanStatus(const char *fName,const char *kicked,const char * kicker,
			const char *kicker_mask,const char *reason);
	virtual void setProperties(KviWindowProperty *p);
	virtual void saveProperties();
	KviIrcUserChanList * userList();
//	void prepareToEditMasks();
protected:	// Protected methods
	void setTopicToolTip();
	void setModeToolTip();
	virtual QPixmap * myIconPtr();
	virtual void applyOptions();
	void applyLabelsOptions();
	virtual void resizeEvent(QResizeEvent *);
protected slots:
	void viewRightClicked(KviIrcView *);
	void viewPopupClicked(const KviStr &dataBuffer);
	void listBoxRightClicked();
	void userlistPopupClicked(const KviStr &dataBuffer);
	void topicEditCompleted();
	void modeEditCompleted(const char *modeDiff,const char * additionalModeChange);
	void maskEditCompleted(char aFlag,const char *masksToRemove);
	void banEditCompleted(const char * masksToRemove);
	void banExceptEditCompleted(const char * masksToRemove);
	void inviteExceptEditCompleted(const char * masksToRemove);
	void usersLabelRightClicked();
	void doEditTopic();
	void doEditModes();
	void doEditMasks();
	void doEditBans();
	void doEditBanExceptions();
	void doEditInviteExceptions();
//	void absurdWorkaroundForMaskEditorFocus();
//	void maskEditorGotFocus();
};

#endif //!_KVI_CHANNEL_H_INCLUDED_
