#ifndef _KVI_VARCACHE_H_INCLUDED_
#define _KVI_VARCACHE_H_INCLUDED_

//
//   File : kvi_varcache.h (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_varcache.h)
//   Last major modification : Mon Feb 15 1999 01:10:34 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"

#include <qlist.h>

class KviVariableCache;

typedef struct KviVariable //Variable entry
{
	KviStr szName;
	KviStr szValue;
};

typedef struct KviDictionary //Array like dictionary %dict[key]
{
	KviStr szName; // dict name (corresponds to the array name)
	KviVariableCache * m_pVarCache; // values associated to each key
};

class KviVariableCache
{
	friend class KviUserParser;
	friend class KviVariablesEditor;
public:
	KviVariableCache();
	~KviVariableCache();
protected:
	QList<KviVariable> *m_pVarList;
	QList<KviDictionary> *m_pDictList;
protected:
	KviVariable * insertNewVariable(const char *name,const char *value);
	KviVariable * set(const char *name,const char *value);
	void concat(const char *name,const char *value);
	void concatWithSeparator(const char *name,char sep,const char *value);
	void unset(const char *name);
	const char *find(const char *name);
	QList<KviVariable> * variableList(){ return m_pVarList; };
	KviVariable * getVariable(const char *name);
	// Dictionaries
	void deleteDict(KviDictionary * dict);
	KviDictionary * insertNewDict(const char *name);
	KviDictionary * getDict(const char *name);
//	void insertNewDictVariable(const char *dictname,const char *varname,const char *value);
	KviVariable * getDictVariable(const char *dictname,const char *varname);
	const char *findDictVariable(const char *dictname,const char *varname);
	KviVariable * setDictVariable(const char *dictname,const char *varname,const char *value);
	void unsetDictVariable(const char *dictname,const char *varname);
	void concatDictVariable(const char *dictname,const char *varname,const char *value);
	void concatWithSeparatorDictVariable(const char *dictname,const char *varname,char sep,const char *value);
	QList<KviDictionary> * dictList(){ return m_pDictList; };
};

#endif //!_KVI_VARCACHE_H_INCLUDED_
