//
//   File : kvi_listview.cpp (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_listview.cpp)
//   Last major modification : Tue May 11 1999 00:03:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_listview.h"

#include <qnamespace.h>

//=============================================================================
//
// ### Field editor for QListView ###
//
//=============================================================================

KviFieldEditor::KviFieldEditor(QWidget *parent)
:QLineEdit(parent)
{
	hide();
//	connect(this,SIGNAL(returnPressed()),this,SLOT(pressedReturnKey()));
//	setFrameStyle(QFrame::Panel|QFrame::Sunken);...oops....
}

KviFieldEditor::~KviFieldEditor(){}

void KviFieldEditor::edit(const QString &str,bool bEnd)
{
	setText(str);
	if(bEnd)end(false);
	else home(false);
	show();
	grabMouse();
	setFocus();
}

void KviFieldEditor::keyPressEvent(QKeyEvent *e)
{
	if(e->key() == Qt::Key_Return){
		QLineEdit::keyPressEvent(e);
		terminateEdit(true);
		e->accept();
	} else if(e->key() == Qt::Key_Up){
		QLineEdit::keyPressEvent(e);
		emit keyUpPressed();
		e->accept();		
	} else if(e->key() == Qt::Key_Down){
		QLineEdit::keyPressEvent(e);
		emit keyDownPressed();
		e->accept();
	} else if(e->key() == Qt::Key_Right){
		if((unsigned int)cursorPosition() == text().length()){
			QLineEdit::keyPressEvent(e);
			emit keyRightPressed();
			e->accept();	
		} else QLineEdit::keyPressEvent(e);
	} else if(e->key() == Qt::Key_Left){
		if(cursorPosition() == 0){
			QLineEdit::keyPressEvent(e);
			emit keyLeftPressed();
			e->accept();
		} else QLineEdit::keyPressEvent(e);
	} else QLineEdit::keyPressEvent(e);
}

void KviFieldEditor::mousePressEvent(QMouseEvent *e)
{
	//if the mouse is outside of this widget release...
	if(!rect().contains(e->pos()))terminateEdit(true);
	else QLineEdit::mousePressEvent(e);
}

void KviFieldEditor::terminateEdit(bool bCommitChanges)
{
	releaseMouse();
	if(isVisible()){
		hide();
		if(bCommitChanges)emit editFinished(text());
		setText("");
	}
}

//void KviFieldEditor::handleKeyEvent(QKeyEvent *e){ keyPressEvent(e); }
void KviFieldEditor::focusOutEvent(QFocusEvent *){ terminateEdit(true); }
//void KviFieldEditor::pressedReturnKey(){ terminateEdit(true); }




KviListView::KviListView(QWidget * par)
:QListView(par)
{
	connect(this,SIGNAL(doubleClicked(QListViewItem *)),this,SLOT(itemDoubleClicked(QListViewItem *)));
	m_pEdit = new KviFieldEditor(viewport());
	connect(m_pEdit,SIGNAL(editFinished(const QString &)),this,SLOT(editTerminated(const QString &)));
	connect(m_pEdit,SIGNAL(keyUpPressed()),this,SLOT(editorKeyUp()));
	connect(m_pEdit,SIGNAL(keyDownPressed()),this,SLOT(editorKeyDown()));
	connect(m_pEdit,SIGNAL(keyLeftPressed()),this,SLOT(editorKeyLeft()));
	connect(m_pEdit,SIGNAL(keyRightPressed()),this,SLOT(editorKeyRight()));
	m_iColumnCount = 0;
	m_pCurEditedItem = 0;
	m_iCurEditedColumn = -1;
	setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
	setAllColumnsShowFocus(true);

	if(parent()){
		QWidget * w = (QWidget *)parent();
		while(w){
			w->installEventFilter(this);
			w = (QWidget *)w->parent();
		}
	}
}

KviListView::~KviListView()
{
}

int KviListView::addColumn(const QString &label,int width)
{
	m_iColumnCount++;
	return QListView::addColumn(label,width);
}

void KviListView::itemDoubleClicked(QListViewItem *it)
{
	if(!it)return;
	QPoint pnt = QCursor::pos();
	pnt = viewport()->mapFromGlobal(pnt);

	int col = 0;
	int xLeft = - contentsX();
	while(col < m_iColumnCount){
		xLeft += columnWidth(col);
		if(pnt.x() < xLeft){
			editField(it,col);
			return;
		}
		col++;
	}
}

void KviListView::editField(QListViewItem *it,int column,bool bEnd)
{
	QRect rct = itemRect(it);
	int fieldWidth = columnWidth(column);
	int fieldX = - contentsX();
	for(int i = 0;i< column;i++)fieldX += columnWidth(i);
	m_pEdit->move(fieldX - 1,rct.top() - 1);
	m_pEdit->resize(fieldWidth + 2 ,rct.height() + 2);
	m_pCurEditedItem = it;
	m_iCurEditedColumn = column;
	m_pEdit->edit(it->text(column),bEnd);
}

void KviListView::editTerminated(const QString &newText)
{
	if(m_pCurEditedItem && (m_iCurEditedColumn > -1) && (m_iCurEditedColumn < m_iColumnCount))
		m_pCurEditedItem->setText(m_iCurEditedColumn,newText);
	m_pCurEditedItem = 0;
	m_iCurEditedColumn = -1;
	setFocus();
}

bool KviListView::eventFilter(QObject * o,QEvent * e)
{
	if(m_pEdit->isVisible()){
		if((e->type() == QEvent::Accel)||(e->type() == QEvent::KeyPress)){
			if(((QKeyEvent *)e)->key() != Qt::Key_Tab)m_pEdit->handleKeyEvent((QKeyEvent *)e);
			else editorKeyRight();
			((QKeyEvent *)e)->accept();
			return true;
		}
	}
	return QListView::eventFilter(o,e);
}

void KviListView::editorKeyLeft()
{
	//Accept the previous changes...
	QListViewItem * i = m_pCurEditedItem;
	int idx = m_iCurEditedColumn;
	m_pEdit->terminateEdit(true);
	//And edit the next field
	--idx;
	if(idx >= 0)editField(i,idx);
	else editField(i,m_iColumnCount - 1);
}

void KviListView::editorKeyRight()
{
	//Accept the previous changes...
	QListViewItem * i = m_pCurEditedItem;
	int idx = m_iCurEditedColumn;
	m_pEdit->terminateEdit(true);
	//And edit the next field
	++idx;
	if(idx < m_iColumnCount)editField(i,idx,false);
	else editField(i,0,false);
}

void KviListView::editorKeyUp()
{
	QListViewItem * i = m_pCurEditedItem ? m_pCurEditedItem->itemAbove() : 0;
	if(!i)return;
	int idx = m_iCurEditedColumn;
	m_pEdit->terminateEdit(true);
	//And edit the next field
	editField(i,idx);
//	ensureVisible(i);
}

void KviListView::editorKeyDown()
{
	QListViewItem * i = m_pCurEditedItem ? m_pCurEditedItem->itemBelow() : 0;
	if(!i)return;
	int idx = m_iCurEditedColumn;
	m_pEdit->terminateEdit(true);
	//And edit the next field
	editField(i,idx);
//	ensureVisible(i);
}

void KviListView::drawContentsOffset(QPainter *p,int ox,int oy,int cx,int cy,int cw,int ch)
{
	QListView::drawContentsOffset(p,ox,oy,cx,cy,cw,ch);
//	debug("%d,%d,%d,%d,%d,%d",ox,oy,cx,cy,cw,ch);
	int r1,g1,b1;
	int r2,g2,b2;
	colorGroup().text().rgb(&r1,&g1,&b1);
	colorGroup().base().rgb(&r2,&g2,&b2);
	QColor clr((r1 + r2) >> 1,(g1 + g2) >> 1,(b1 + b2) >> 1);
	p->setPen(QPen(clr,1,Qt::DotLine));
	int nCol = 0;
	int curX = 0;
	while((nCol <= columns()))
	{
		if((curX > ox) && (curX >= cx) && (curX <= cx + cw))
		{
			int realX = (curX - ox) - 1;
			int realY = (cy - oy);
			p->drawLine(realX,- oy,realX,realY + ch);
		}
		curX += columnWidth(nCol);
		nCol++;
	}
	QListViewItem * it = itemAt(QPoint(1,cy - oy));
	if(!it)return;
	QRect r =  itemRect(it);
	int curY = r.y();
	int itmH = r.height();
	if(itmH <= 0)return; // no more rectangles ?
	int idx = it->itemPos() / itmH;
	int realBottom = cy + ch - oy;
	while((curY < realBottom) && (idx <= childCount()))
	{
		if(curY > 0)
		{
			int realX = (cx - ox);
			p->drawLine(- ox,curY,realX + cw,curY);	
		}
		curY += itmH;
		idx++;
	}
}


#include "m_kvi_listview.moc"
