#ifndef _KVI_CONFIG_H_INCLUDED_
#define _KVI_CONFIG_H_INCLUDED_

//
//   File : kvi_config.h (/usr/build/NEW_kvirc/kvirc/kvilib/kvi_config.h)
//   Last major modification : Thu Jan 14 1999 18:01:22 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"

#include <qdict.h>
#include <qcolor.h>
#include <qfont.h>
#include <qrect.h>

typedef QDict<KviStr> KviStrDict;

class KviConfig
{
public:
	KviConfig(const char *filename);
	~KviConfig();
private:
	QDict<KviStrDict> *m_pDict;
	KviStr m_szFileName;
	bool m_bDirty;
	KviStr m_szStrBuffer;
	KviStr m_szGroup;
private:
	bool load();
	bool save();
	KviStrDict * getCurrentGroup();
public:
	void clear();
	void clearGroup(const char *szGroup);
	void clearKey(const char *szKey);
	bool sync(){ return save(); };
	bool hasKey(const char *szKey);
	void setGroup(const char *szGroup){ m_szGroup = szGroup; };
	void getContentsString(KviStr &buffer);
	const char *group(){ return m_szGroup.ptr(); };
	void writeEntry(const char *szKey,const char *szValue);
	const char * readEntry(const char *szKey,const char *szDefault = 0);
	void writeEntry(const char *szKey,const QColor &clr);
	QColor readColorEntry(const char *szKey,const QColor &clr);
	void writeEntry(const char *szKey,QFont &fnt);
	QFont readFontEntry(const char *szKey,QFont &fnt);
	void writeEntry(const char *szKey,bool bTrue);
	bool readBoolEntry(const char *szKey,bool bTrue);
	QRect readRectEntry(const char *szKey,const QRect &rct);
	void writeEntry(const char *szKey,const QRect &rct);
/*	void writeEntry(const char *szKey,unsigned long lValue);
	unsigned long readULongEntry(const char *szKey,unsigned long lDefault);
	void writeEntry(const char *szKey,long lValue);
	long readLongEntry(const char *szKey,long lDefault);*/
	void writeEntry(const char *szKey,int iValue);
	int readIntEntry(const char *szKey,int iDefault);
	void writeEntry(const char *szKey,unsigned short int usValue);
	unsigned short int readUShortEntry(const char *szKey,unsigned short int usDefault);
	void writeEntry(const char *szKey,unsigned int iValue);
	unsigned int readUIntEntry(const char *szKey,unsigned int iDefault);
	void writeEntry(const char *szKey,char iValue);
	char readCharEntry(const char *szKey,char iDefault);
	void writeEntry(const char *szKey,unsigned char iValue);
	unsigned char readUCharEntry(const char *szKey,unsigned char iDefault);

	static void getFontProperties(KviStr & buffer,QFont *fnt);
	static void setFontProperties(KviStr & str,QFont *fnt);
};

#endif //!_KVI_CONFIG_H_INCLUDED_
