/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#include <qptrlist.h>
#include <qstring.h>


//Redefined here to compile correctly (crossed-header problem)
class LogLevel;
typedef QPtrList<LogLevel> LogLevels;


//Redefined here to compile correctly (crossed-header problem)
class LogMode;
typedef QPtrList<LogMode> LogModes;

#define DEFAULT_FOLDER "/var/log"

/**
 * Icon name of KSystemLog
 */
#define KSYSTEMLOG_ICON "ksystemlog"



// String was "none"
#define NONE_LOG_LEVEL_ICON "help" 

#define DEBUG_LOG_LEVEL_ICON "attach"
#define INFORMATION_LOG_LEVEL_ICON "messagebox_info"
#define NOTICE_LOG_LEVEL_ICON "endturn"
#define WARNING_LOG_LEVEL_ICON "messagebox_warning"
#define ERROR_LOG_LEVEL_ICON "messagebox_critical"
#define CRITICAL_LOG_LEVEL_ICON "core"
#define ALERT_LOG_LEVEL_ICON "kalarm"
#define EMERGENCY_LOG_LEVEL_ICON "exit"

enum logLevelIds {
	NONE_LOG_LEVEL_ID=0,
	DEBUG_LOG_LEVEL_ID,
	INFORMATION_LOG_LEVEL_ID,
	NOTICE_LOG_LEVEL_ID,
	WARNING_LOG_LEVEL_ID,
	ERROR_LOG_LEVEL_ID,
	CRITICAL_LOG_LEVEL_ID,
	ALERT_LOG_LEVEL_ID,
	EMERGENCY_LOG_LEVEL_ID,
};

enum groupByType {
	NO_GROUP_BY=0,
	GROUP_BY_LOG_LEVEL,
	GROUP_BY_DAY,
	GROUP_BY_HOUR,
	GROUP_BY_LOG_FILE,
	GROUP_BY_COLUMN
};

//This variable only counts GROUP_BY methods != than GROUP_BY_COLUMN
#define DEFAULT_GROUP_BY_COUNT 5

#define NO_GROUP_BY_ICON "cancel"
#define GROUP_BY_LOG_LEVEL_ICON INFORMATION_LOG_LEVEL_ICON
#define GROUP_BY_DAY_ICON "today"
#define GROUP_BY_HOUR_ICON "clock"
#define GROUP_BY_LOG_FILE_ICON "file"

#define GROUP_BY_COLUMN_ICON "view_text"


//Icon of the Group By action
#define GROUP_BY_ICON "view_tree"


/**
 * Icon names of different existing modes
 */
#define NO_MODE_ICON "ksystemlog"

#define OPENING_MODE_ICON "file"

#define SYSTEM_MODE_ICON "hwinfo"
#define KERNEL_MODE_ICON "openterm"
#define XORG_MODE_ICON "x"
#define BOOT_MODE_ICON "system"
#define AUTHENTICATION_MODE_ICON "kuser"
#define DAEMON_MODE_ICON "misc"
#define CRON_MODE_ICON "history"


#define SAMBA_MODE_ICON "samba"
#define PROFTP_MODE_ICON "ftp"

#define ACPID_MODE_ICON "connect_no"

#define CUPS_MODE_ICON "fileprint"
#define CUPS_ACCESS_MODE_ICON "history"

#define APACHE_MODE_ICON "network"
#define APACHE_ACCESS_MODE_ICON "history"

#define POSTFIX_MODE_ICON "email"

#define SAMBA_MODE_ICON "samba"

class Globals {
	public:
		static void setupLogModes();
		
		static void setupLogLevels();
		
		/**
		 * Existing Log modes. The id value corresponds to the index in the vector
		 */
		static LogModes logModes;
		
		/**
		 * These value are only pointers to item of the previous vector,
		 * they are provided for convenience
		 */
		static LogMode* noMode;
		static LogMode* openingMode;
		static LogMode* systemMode;
		static LogMode* kernelMode;
		static LogMode* xorgMode;
		static LogMode* bootMode;
		static LogMode* authenticationMode;
		static LogMode* cronMode;
		static LogMode* daemonMode;
		
		static LogMode* acpidMode;
		static LogMode* cupsMode;
		static LogMode* cupsAccessMode;

		static LogMode* apacheMode;
		static LogMode* apacheAccessMode;

		static LogMode* postfixMode;
		
		static LogMode* sambaMode;
		
		/**
		 * Existing Log levels. The id value corresponds to the index in the vector
		 */
		static LogLevels logLevels;
		
		/**
		 * These value are only pointers to item of the previous vector, 
		 * they are provided for convenience
		 */
		static LogLevel* noneLogLevel;
		static LogLevel* debugLogLevel;
		static LogLevel* informationLogLevel;
		static LogLevel* noticeLogLevel;
		static LogLevel* warningLogLevel;
		static LogLevel* errorLogLevel;
		static LogLevel* criticalLogLevel;
		static LogLevel* alertLogLevel;
		static LogLevel* emergencyLogLevel;
	
};


#endif
