#ifndef __LOCKOUT_H__
#define __LOCKOUT_H__

#include <kpanelapplet.h>

class QBoxLayout;
class QToolButton;

/**
 * @short A KShutDown panel applet.
 * Based on the Lockout applet.
 */
class Lockout: public KPanelApplet
{
	Q_OBJECT
public:
	/**
	 * Constructs a new applet.
	 * @param configFile A configuration file (provided by the Kicker)
	 * @param parent A parent widget
	 */
	Lockout(const QString& configFile, QWidget *parent = 0);

	/**
	 * Destructor.
	 */
	~Lockout();

	/**
	 * Returns a suggested height for a given @p width.
	 */
	int heightForWidth(int width) const;

	/**
	 * Returns a suggested width for a given @p height.
	 */
	int widthForHeight(int height) const;
protected:
	/**
	 * Filters events.
	 */
	virtual bool eventFilter(QObject *, QEvent *);

	/**
	 * Mouse double click event handler.
	 */
	virtual void mouseDoubleClickEvent(QMouseEvent *);

	/**
	 * Mouse move event handler.
	 */
	virtual void mouseMoveEvent(QMouseEvent *);

	/**
	 * Mouse press event handler.
	 */
	virtual void mousePressEvent(QMouseEvent *);

	/**
	 * Mouse release event handler.
	 */
	virtual void mouseReleaseEvent(QMouseEvent *);
private:
	bool
		_showLockButton,
		_transparent;
	QToolButton
		*_lockButton,
		*_logoutButton;
	QBoxLayout *_layout;
	QToolButton *addButton(const QString &icon, const QString &text);
	void checkLayout(const int height) const;
	void propagateMouseEvent(const QMouseEvent *) const;
	void runKShutDown() const;
private slots:
	void slotConfigure();
	void slotIconChanged();
	void slotLock();
	void slotLogout();
	void slotShowLockButton();
	void slotTransparent();
};

#endif // __LOCKOUT_H__
