/*
	configuration.h - A configuration
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __CONFIGURATION_H__
#define __CONFIGURATION_H__

#include <kconfigskeleton.h>

#define kshutdownrc Config::getInstance()->getInstance()

/**
 * @short A configuration reader/writer.
 * Use the @c kshutdownrc macro to access these members.
 */
class Config: public KConfigSkeleton
{
public:
	// automation
	bool cdTrayClose;
	ItemBool *i_cdTrayClose;
	QString cdTrayCloseCommand;
	ItemString *i_cdTrayCloseCommand;

	// custom message
	bool customMessageEnabled;
	ItemBool *i_customMessageEnabled;
	QString customMessageCommand;
	ItemString *i_customMessageCommand;

	// general
	int generalAction;
	int generalDelayType;
	QDateTime generalDateTime;

	// statistics
	bool statsLongFormat;
	ItemBool *i_statsLongFormat;
	bool statsToggleFromField;
	ItemBool *i_statsToggleFromField;

	// system tray
	int systemTray;
	ItemInt *i_systemTray;

	// warning message
	bool warningMessageEnabled;
	ItemBool *i_warningMessageEnabled;
	int warningMessageDelay;
	ItemInt *i_warningMessageDelay;

	/**
	 * Constructs and returns a singleton instance of the configuration.
	 */
	inline static Config *getInstance()
	{
		if (!_instance)
			_instance = new Config();

		return _instance;
	}
private:
	Config();
	static Config *_instance;
};

#endif // __CONFIGURATION_H__
