/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*                  Copyright (c) 1985-2006 AT&T Corp.                  *
*                      and is licensed under the                       *
*                  Common Public License, Version 1.0                  *
*                            by AT&T Corp.                             *
*                                                                      *
*                A copy of the License is available at                 *
*            http://www.opensource.org/licenses/cpl1.0.txt             *
*         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                  David Korn <dgk@research.att.com>                   *
*                   Phong Vo <kpv@research.att.com>                    *
*                                                                      *
***********************************************************************/
#pragma prototyped

#include <ast.h>

#if _lib_mkfifo

NoN(mkfifo)

#else

#include <ls.h>
#include <error.h>

#ifndef ENOSYS
#define ENOSYS	EINVAL
#endif

int
mkfifo(const char* path, mode_t mode)
{
#ifdef S_IFIFO
	return mknod(path, S_IFIFO|(mode & ~S_IFMT), 0);
#else
	errno = ENOSYS;
	return -1;
#endif
}

#endif
