/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#ifndef _PLAYER_H_
#define _PLAYER_H_

struct Player_pl;

#include "relay.h"
#include "weapons/weapon.h"

/* These have slightly different meanings in pregame and in game.  In
   pregame, observers can't ready and aren't counted to play.  Ready
   and notready are normal players who of course have either indicated
   if they are ready to play or not.  In game, observers watch but
   don't take part in the game.  Notready players started out ready
   but are dead, and ready players are alive and playing. */
typedef enum
{ OBSERVER = 0, NOTREADY, READY, SCORING }
Ready_pl;

typedef enum
{ IMPACT = 0, EXPLOSIVE, FALLING }
DamageSource_pl;

typedef enum
{ WEAPON = 0, SHIELD }
ItemType_pl;

/* scoring #defines */
#define SCORE_SUICIDE  (-100/(gm_numberPlayers > 1 ? gm_numberPlayers-1 : 1))
#define SCORE_KILL     (100/(gm_numberPlayers > 1 ? gm_numberPlayers-1 : 1))
#define SCORE_DONE(pl) ((100*(pl)->killNumber)/(gm_numberPlayers > 1 ? gm_numberPlayers-1 : 1))
#define SCORE_DAMAGE   (15)

/* Max number of players */
#define MAX_TANKS 10

/* ItemStock is a CIRCULAR linked list! */
typedef struct ItemStock_pl
{
    struct ItemStock_pl *next;
    struct ItemStock_pl *prev;
    ItemType_pl type;
    void *info;
    void (*activate) (void *info);
    int count;
}
ItemStock_pl;

typedef struct Player_pl
{
    char *name;

    Ready_pl ready;
    int x, y;			/* x is at the middle of the tank, y is the floor (tank treads) */
    int ox, oy;			/* old x/y for tank movement animation */
    double vy;			/* _tank_ falling velocity */
    /*double vx; * TODO: Horizontal movement for tanks, like projectiles */
    int tankcolor;
    double fire_angle;
    double fire_velocity;
    int barreloff_left;		/* -10 */
    int barreloff_right;	/* +10 */
    int barreloff_x;
    int barreloff_y;		/*  15 */
    struct Player_pl *next;
    struct Player_pl *prev;
    int id;
    int money;
    int armor;
    int shield;
    void (*shield_influence) (struct Player_pl * p,
			      struct Projectilelist_bal * prj);
    void (*shield_impact) (struct Player_pl * p,
			   struct Projectilelist_bal * prj);
    ItemStock_pl *itemstock;
    int score;			/* total score for this game */
    int roundScore;		/* score for this ROUND only */
    int killNumber;		/* what order did you die in */
    int last_hit; /* the last player's id that damaged this tank */
    char fired;
}
Player_pl;

extern Player_pl *pl_begin, *pl_end;

Player_pl *plLookupPlayer(int id);
Player_pl *plCreatePlayer();
int plBuyWeapon(int id, char *wpn, int count, void (*activate) (void *));
int plCountWeaponInStock(Player_pl * pl, struct Weapon_wep *wpn);
int plUseWeaponInStock(Player_pl * pl, struct Weapon_wep *wpn, int count);
int plAddWeaponToStock(Player_pl * pl, struct Weapon_wep *wpn, int count,
		       void (*activate) (void *));
void plDestroyTank(Player_pl * pl, int srcid, int causeid);
int plDamageTank(Player_pl * pl, DamageSource_pl ds, int srcid, int causeid, int amt);
int plPlayerInCircleArea(Player_pl * pl, int x, int y, int r);
int plCalcTankFall();
int plSellWeapon(int id, char *wpn, int count);
void plClearAllWeapon(int id);

#define TANKSCREENRATIO_X 30
#define TANKSCREENRATIO_Y 50

extern int pl_barrelen;
extern int pl_tankheight;
extern int pl_tankwidth;
extern int server_color; /* Last - 1 color */
extern int observer_color; /* Last color */


#endif
