
#include <kore/version.h>
#include <kore/servicemanager.h>

#include <iostream>

#include "koredlg_cout.h"

#define KDC_MAJOR 0
#define KDC_MINOR 0
#define KDC_REVISION 1
#define KDC_VERSION "0.0.1"
#define KDC_API_MAJOR 0
#define KDC_API_MINOR 0
#define KDC_API_REVISION 2
#define KDC_API_VERSION "0.0.2"
#define KDC_NAME "KoreDialog <cout>"
#define KDC_TYPE KOREDLG_TYPE
#define KDC_DESCRIPTION "'cout'-based implementation for KoreDialog"
#define KDC_SERVICE KOREDLG_SERVICE "/cout"
#define KDC_SERVICE_DESCRIPTION "'cout'-based '" KOREDLG_SERVICE "' service"

KoreDlg_cout::KoreDlg_cout()
{
    _kdcVersion = new Version(KDC_MAJOR,KDC_MINOR,KDC_REVISION,KDC_VERSION);
    _kdcAPIVersion = new Version(KDC_API_MAJOR,KDC_API_MINOR,KDC_API_REVISION,KDC_API_VERSION);
    _kdcInfo = new Info(this, KDC_NAME, KDC_TYPE, KDC_DESCRIPTION, _kdcVersion, _kdcAPIVersion);
    setInfo(_kdcInfo);
    _kdcService = new Service(this, KDC_SERVICE, KDC_SERVICE_DESCRIPTION);
    addService(_kdcService);
    _kdService = new Service(this, KOREDLG_SERVICE, KDC_SERVICE_DESCRIPTION);
    addService(_kdService);
}
KoreDlg_cout::~KoreDlg_cout()
{
    delete _kdcInfo;
    delete _kdcVersion;
    delete _kdcAPIVersion;
    delete _kdcService;
    delete _kdService;
}

void KoreDlg_cout::showMessage(const char *msg)
{
    cout << msg << endl;
}
