
#include <kore/version.h>
#include <kore/serviceprovider.h>
#include <kore/servicemanager.h>
#include <kore/kernel.h>
#include <iostream>

using namespace kore;

ServiceProvider::Service::Service(ServiceProvider* provider,const char* name,const char* description)
{
    _provider = provider;
    _name = name;
    _description = description;
    _parent = 0;
    string srv(name);
    unsigned i = 0;
    unsigned j = 0;
    // split the string into pieces
    while( j < srv.size() )
    {
        j = srv.find('/',i);
        if( srv[j] == '/' )
        {
            _path.push_back(string(srv, i, j - i));
//            cout << string(srv, i, j-i) << "/\n";
        }
        else
        {
            _leaf = string(srv, i, j-i);
//            cout << string(srv, i, j-1) << endl;
        }
        i = j+1;
    }
//        cout << "============\n";
}
ServiceProvider* ServiceProvider::Service::provider() const
{
    return _provider;
}
const char* ServiceProvider::Service::name() const
{
    return _name;
}
ServiceProvider::Service::operator const char* () const
{
    return _name;
}
const char* ServiceProvider::Service::description() const
{
    return _description;
}

ServiceProvider::ServiceProvider()
{
}
ServiceProvider::ServiceProvider(const Info* info):Module(info)
{
}
ServiceProvider::~ServiceProvider()
{
}

void ServiceProvider::addService(const ServiceProvider::Service* service)
{
    _services.push_back(service);
}

const ServiceProvider::Service** ServiceProvider::services() const
{
    int n = _services.size();
    const Service** srv = new const Service*[n+1];
    int i;
    for( i = 0; i < n; i++ )
        srv[i] = _services[i];
    srv[i] = 0;
    return srv;
}

const ServiceProvider::Service* ServiceProvider::service(const char* srv) const
{
    if( !srv )
        return 0;
    Service serv(0, srv, 0);
    return service(&serv);
}

const ServiceProvider::Service* ServiceProvider::service(const Service* srv) const
{
    if( !srv )
        return 0;
    const Service* serv = 0;
    serv = passiveService(srv);
    if( serv )
        return serv;
    else
        return activeService(srv);
}

const ServiceProvider::Service* ServiceProvider::passiveService(const Service* srv) const
{
    // paranoia
    if( !srv )
        return 0;
    const Service* res = 0;
    const Service** srvs = services();
    for(int i=0; srvs[i]; i++)
        if( (srvs[i] == srv) || ( strcmp(srvs[i]->name(),srv->name()) == 0 ) )
        {
            res = srvs[i];
            break;
        }
    delete[] srvs;
    return res;
}

const ServiceProvider::Service* ServiceProvider::activeService(const Service* srv) const
{
    return 0;
}

void ServiceProvider::registeringProvider(ServiceManager* sm)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : registering to " << sm->info()->name() << " " << (const char*)*(sm->info()->version()) << endl;
}
void ServiceProvider::providerRegistered(ServiceManager* sm)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : registered to " << sm->info()->name() << " " << (const char*)*(sm->info()->version()) << endl;
}
void ServiceProvider::unregisteringProvider(ServiceManager* sm)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : unregistering from " << sm->info()->name() << " " << (const char*)*(sm->info()->version()) << endl;
}
void ServiceProvider::providerUnregistered(ServiceManager* sm)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : unregistered from " << sm->info()->name() << " " << (const char*)*(sm->info()->version()) << endl;
}

void ServiceProvider::registeringService(ServiceManager* sm,const Service* srv)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : registering service " << srv->name() << " (" << srv->description() << ") to " << sm->info()->name() << " " << (const char*)*(sm->info()->version()) << endl;
}
void ServiceProvider::serviceRegistered(ServiceManager* sm,const Service* srv)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : registered service " << srv->name() << " (" << srv->description() << ") to " << sm->info()->name() << " " << (const char*)*(sm->info()->version()) << endl;
}
void ServiceProvider::unregisteringService(ServiceManager* sm,const Service* srv)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : unregistering service " << srv->name() << " (" << srv->description() << ") from " << sm->info()->name() << " " << (const char*)*(sm->info()->version()) << endl;
}
void ServiceProvider::serviceUnregistered(ServiceManager* sm,const Service* srv)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : unregistered service " << srv->name() << " (" << srv->description() << ") from " << sm->info()->name() << " " << (const char*)*(sm->info()->version()) << endl;
}
