/* @(#) vm.c 1.7 @(#) */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: VM
\***************************************************************/

#define _KOALAMUD_VM_C "@(#) nitehawk@winghove.1ststep.net|lib/vm/vm.c|20000313061113|12880 @(#)"

#include "autoconf.h"
#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

#include "module.h"
#include "vm.h"
#include "vminternal.h"

/* This file contains the API interface to the koala vm driver */

/* Global variables */

/* Module data */
module_t	vmmodule =
{
	"VM Driver",
	"@(#) vm.c 1.7 @(#)",
	MODSTATE_UNDEFINED,
	vmstartup,
	vmlinkup,
	vmshutdown
};

/* We define a setinel module definition here for usage in the vm driver */
module_t vmnullmodule =
{
	NULL,
	NULL,
	MODSTATE_UNDEFINED,
	NULL,
	NULL,
	NULL
};

/* List of VM Driver support modules */
pmodule vmsupport[] =
{
	&bigbufmodule,
	&dbmodule,
	&vmnullmodule,
};

/* We only initialize these to defaults of they are null in linkup */
vmconfig_t vmconfig =
{
	NULL,	/* Base DB Path */
	NULL,	/* Base root DB name */
	NULL,	/* Extension */
};

/********************************
 * State Control				*
 *******************************/
/* Speed is not critical for the state control functions, as they are only
 * going to be called during startup and shutdown. */
/* vmstartup - preform vm startup tasks -  Only initialize the memory state
 * variables.  Database and full vm driver will be brought online just before
 * starting the daemon loop
 */
int vmstartup(void)
{
	/* Must either be undefined - meaning we have not done a startup this run,
	 * or stopped, meaning we are restarting during the same binary run */
	if (!(vmmodule.state == MODSTATE_UNDEFINED ||
			vmmodule.state == MODSTATE_STOPPED))
		return VMBADSTATE;
	/* Reflect that we are starting up */
	vmmodule.state = MODSTATE_STARTUPINPROGRESS;

	/* Startup vm support modules */
	{
		int numattempted = 0;
		int errors = 0;

		modstartup(vmsupport, &vmnullmodule, &numattempted, &errors);
	}

	/* All done with startup */
	vmmodule.state = MODSTATE_STARTED;

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* vmlinkup - This brings the vm driver fully online.  We expect the
 * 'vmconfig' variable to be a vmconfig_t struct with the database path and
 * database base name filled in.  The other fields can be filled in as well
 * to control certain pieces of the vm driver.  See the type definition in
 * include/vm.h for more information.
 */
int vmlinkup(void)
{
	/* If the current state is not 'STARTED', then we are not prepared to do
	 * the linkup */
	if (vmmodule.state != MODSTATE_STARTED)
		return VMBADSTATE;
	/* show that we are doing linkup */
	vmmodule.state = MODSTATE_LINKUPINPROGRESS;

	/* Link vm support modules */
	{
		int numattempted = 0;
		int errors = 0;

		modlinkup(vmsupport, &vmnullmodule, &numattempted, &errors);
	}

	/* Linkup complete */
	vmmodule.state = MODSTATE_LINKED;

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* vmshutdown - This function preforms a full backup of the database and
 * cleans up all in memory data.
 */
int vmshutdown(void)
{
	/* Can't shutdown unless we are currently 'linked' */
	if (vmmodule.state != MODSTATE_LINKED)
		return VMBADSTATE;
	/* show that we are doing shutdown */
	vmmodule.state = MODSTATE_SHUTDOWNINPROGRESS;

	/* Shutdown vm support modules */
	{
		int numattempted = 0;
		int errors = 0;

		modshutdown(vmsupport, &vmnullmodule, &numattempted, &errors);
	}

	/* shutdown complete */
	vmmodule.state = MODSTATE_STOPPED;

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* Error printing functions and support */
char *vmerrtbl[] =
{
	"No Error",
	"Out of memory",
	"Bad state change attempt",
};

char *vmstrerr(vmerr_t err)
{
	char *buf = NULL;
	int tblpos = err > 0 ? 0 : err - VMEOFFSET;

	/* Make sure we aren't going to try reading past the end of the error
	 * table
	 */
	if (tblpos >= VMELAST - VMEOFFSET)
	{
		return NULL;
	}

	/* Allocate buf, we expect the caller to clean this up */
	if ((buf = malloc(strlen(vmerrtbl[tblpos]))) == NULL)
	{
		return NULL;
	}

	/* Copy the string into the buffer */
	strcpy(buf, vmerrtbl[tblpos]);

	/* All done */
	return buf;
}
