/* @(#) memory.h 1.8 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: Memory
\***************************************************************/

#ifndef _KOALAMUD_MEMORY_H
#define _KOALAMUD_MEMORY_H "@(#) nitehawk@winghove.1ststep.net|include/memory.h|20001104224529|40562 @(#)"

#include "llist.h"
#include "koalatypes.h"

/* Allocation types */
typedef enum 
{
	ALLOC_GENERIC = 0,  // Memory that will be sticking around for quite a while
	ALLOC_DATABASE,		// Memory allocated for database purposes
	ALLOC_DESCRIPTOR,	// Memory allocated to network descriptors
	ALLOC_TEMP,			// Should stay close to 0
	ALLOC_LLIST,		// Memory used for linked list
	ALLOC_CMDTABLE,		// Command table memory
	ALLOC_STRING,		// Memory used for string storage

	/* This entry *MUST* be last */
	ALLOC_LISTEND,
} kmalloctype;

/* Memory status struct */
typedef struct 
{
	size_t	allocsize;
	int		numobjects;
} memstate_t;
extern memstate_t memstate[ALLOC_LISTEND];

listnodeptr getdescriptorlist(void);
pdescriptor allocdescriptor(void);
void freedescriptor(pdescriptor desc);

inline void *kmalloc(size_t len, kmalloctype type);
inline void kmfree(void *ptr, kmalloctype type);
inline void *krealloc(void *ptr, size_t len, kmalloctype type);

void initmemstate(void) __attribute__ ((constructor));


#endif
