/***************************************************************************
                          knutprefdlg.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTPREFDLG_H
#define KNUTPREFDLG_H

#include "knutnewupsdlg.h"
#include "knutupsdata.h"
#include "knutvardata.h"


#include <kdialogbase.h>
#include <kpushbutton.h>
#include <klistbox.h>
#include <klocale.h>
#include <kfontdialog.h>
#include <kcolorbtn.h>
#include <kcombobox.h>

#include <qwidget.h>
//#include <qstrlist.h>
//#include <qspinbox.h>
//#include <qcheckbox.h>
//#include <qfont.h>
//#include <qlabel.h>

namespace knc {

enum changePref {
  ChangeCountCols =             0x1, //1,
  ChangeCustomBColor =          0x2, //2,
  ChangeMBColor =               0x4, //4,
  ChangeVoltage =               0x8, // 8,
  ChangeFrequency =            0x10, // 16,
  ChangeXFer =                 0x20, // 32,

  ChangeUpsSetting =           0x40, // 64,
  ChangeUpsCount =             0x80, // 128,
  
  ChangeMainPanelSetting =    0x100, // 256,
  ChangeCustomMPanelBColor =  0x200, // 512,
  ChangeMPBColor =            0x400, // 1024,

  ChangeAnalogFont =          0x800, // 2048,
  ChangePanelFont =          0x1000, // 4096,

  ChangeCustomAPanelBColor = 0x2000, // 8192,
  ChangeAPBColor =           0x4000, // 16384,

  ChangeCustomAPanelOColor = 0x8000, // 32768,
  ChangeAPOColor =          0x10000, // 65536,

  ChangeCustomKIconColor =  0x20000, // 131072,
  ChangeKIconBColor =       0x40000, // 262144,

  ChangeToolTip =           0x80000, // 524288,
                                                             
  ChangeTypeOfKIcon =      0x100000,  // 1048576

  ChangeSomeThing =      0x200000  // 1048576 *2
  
  };  
}

class QLabel;
class QFont;
class QCheckBox;
class QRadioButton;
class QSpinBox;

/**
  *@author Daniel Prynych
  */

/**
 * Tato trida je vytvari konfiguracni dialog.
 * @author Daniel Prynych
 * @short Konfiguracni dialog
 * @version 0.7.1
 */
class KNutPrefDlg : public KDialogBase
{
  Q_OBJECT
  public:


/**
 * Konstruktor vytvori konfiguracni dialog.
 *
 * @param upsData Je odkaz na instanci tridy KNutUpsData, ktera spravuje informace o UPS-kach.
 * @param analogData Je odkaz na na instanci tridy KNutVarData, ktera spravuje data o analogovych panelech.
 * @param settingData Je odkaz na strukturu ktera obsahuje hodnoty nastavovane v dialogu.
 * @param upsName Je jmeno aktivni UPS-ky.
 *
 * @since  0.5
 **/
  KNutPrefDlg(KNutUpsData* const upsData, KNutVarData* const analogData, SettingDataDef* const settingData, const QString upsName, QWidget* parent = 0, const char* name = 0, const bool modal = true);

/**
 * @since  0.3
 **/
  ~KNutPrefDlg();

  signals:

/**
 * Signal je aktivovam pokud je zmenen udaj na kterekoliv strance.
 *
 * @param changeSetting Udava, co bylo zmeneno.
 *
 * @since  0.2
 **/
  void signalChangeConfig (unsigned int changeSetting );



  private slots:

/**
 * @internal
 */
  virtual void slotDefault();

/**
 * @internal
 */
  virtual void slotApply();

/**
 * @internal
 */
  virtual void slotOk();

/**
 * @internal
 */
  void slotChangeSettingFont(int index);

/**
 * @internal
 */
  void slotEnableVoltage(bool enable);


/**
 * @internal
 */
  void slotEnableFrequency(bool enable);


/**
 * @internal
 */
  void slotUseCustomBColor(bool enable);

/**
 * @internal
 */
  void slotUseCustomBPanelColor(bool enable);

/**
 * @internal
 */
void slotUseCustomBAnalogColor(bool enable);


/**
 * @internal
 */
void slotUseCustomOAnalogColor(bool enable);

/**
 * @internal
 */
void slotUseCustomBIconColor(bool enable);

  
/**
 * @internal
 */
  void slotNewUps();

/**
 * @internal
 */
  void slotEditUps();

/**
 * @internal
 */
  void slotDeleteUps();

  
  private:

  enum Page {
    mainSettingPage =0,
    upsSettingPage,
    panelSettingPage,
    fontSettingPage,
    analogSettingPage,
    kickerSettingPage
    };

/**
 * @internal
 */
  void initSetting();

/**
 * @internal
 */
  void initUps();

/**
 * @internal
 */
  void initPanel();

/**
 * @internal
 */
  void initFonts();

/**
 * @internal
 */
  void initAnalog ();

/**
 * @internal
 */
  void initDock ();
  


// Soukrome promene
  QString activeUpsName;
  KListBox* ListBox2;
  KNutUpsData* myUpsData;
  KNutVarData* myAnalogData;
  KNutNewUpsDlg* newUpsDlg;

  bool checked; // nastaveno kdyz doslo k zmene v definici UPS
  bool checkedActiveUps; // nastaveno pokud doslo ke zmene na aktivni UPS

  QSpinBox *numberOfColumns;
  KColorButton *BGButton;
  QCheckBox *checkBoxCbc;
  QCheckBox *checkBoxAys;
  QCheckBox *checkBoxMW;
  QCheckBox *xfer;
  QLabel *label3;
  

  QCheckBox *checkBoxOver;
  QCheckBox *checkBoxBL;
  QCheckBox *checkBoxRB;
  QCheckBox *checkBoxCal;
  QCheckBox *checkBoxMFRM;
  QCheckBox *checkBoxMFR;
  QCheckBox *checkBoxModel;
  QCheckBox *checkBoxSerial;
  QCheckBox *checkBoxFirm;
  QCheckBox *checkBoxRun;
  QCheckBox *checkBoxCbpc;
  KColorButton *BGPButton;
  QLabel *label4;

  QRadioButton *vRadioButton1;
  QRadioButton *vRadioButton2;
  QRadioButton *fRadioButton1;
  QRadioButton *fRadioButton2;

  QButtonGroup	*voltageGroup;
  QButtonGroup	*frequencyGroup;
  SettingDataDef* prefData;

  QCheckBox* customFont; // Uzivatelske Font (nepouzit systemove fonty)
  KComboBox *panelFonts;
  KFontChooser *fontWidget;

  QFont aPanelFont; // Analog panel font
  QFont mPanelFont; // Main panel font

  int settingFont; // ktery font nastavujeme


  QCheckBox* checkBoxCbac;
  QCheckBox* checkBoxCoac;
  KColorButton* BGAButton;
  KColorButton* AFingerButton;
  KColorButton* AOKButton;
  KColorButton* AWarnningButton;
  KColorButton* AErrorButton;
  KColorButton* AScaleButton;
  KColorButton* AFontButton;
  QLabel *label5;
  QLabel *label6;
  QLabel *label7;
  QLabel *label8;
  QLabel *label9;
  QLabel *label10;
  QLabel *label11;


  KColorButton *BGIButton;
  QCheckBox *checkBoxCbi;
  QButtonGroup *typeGroup;
  QRadioButton *iconRadioButton1;
  QRadioButton *iconRadioButton2;
  QLabel *label12;
  QCheckBox *checkBoxTTMFR;
  QCheckBox *checkBoxTTModel;
  QCheckBox *checkBoxTTSerial;
  QCheckBox *checkBoxTTFirm;
  QCheckBox *checkBoxTTRun;
  QCheckBox *checkBoxTTCharge;
  QCheckBox *checkBoxTTLoad;

};

#endif
