/***************************************************************************
 *                                                                         *
 *   $FILE$ - A NetworkManager frontend for KDE                            *
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *                                                                         *
 *   Author: Will Stephenson <wstephenson@suse.de>, <thoenig@nouse.net>    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/
#ifndef KNM_NETWORKLISTVIEW_H
#define KNM_NETWORKLISTVIEW_H

#include <klistview.h>

class NetworkManagerInfo;
class NetworkGroupLVI;
class Network;

class KNetworkManagerNetworkListView : public KListView
{
Q_OBJECT
public:
	KNetworkManagerNetworkListView( NetworkManagerInfo * nmi, QWidget * parent = 0, const char * name = 0 );
	virtual ~KNetworkManagerNetworkListView() {}
	// need to make group LVIs not drag enabled.
	// acceptDrag
		// check that the thing under the drop is appropriate
		// groups accept networks
		// networks accept APs and other networks(place after)
		// APs accept other APs
	virtual bool acceptDrag (QDropEvent * event) const;
	// dragObject()
		// set the encoded data to represent what's being dragged
	QDragObject * dragObject();
	QValueList< Network * > changedNetworks() { return m_changedNetworks; }
	QValueList< Network * > deletedNetworks() { return m_deletedNetworks; }
public slots:
	void slotAddNetworkClicked();
	void slotAddAccessPointClicked();
	void slotRemoveItemClicked();
protected slots:
	// slotDropped()
		// connect to KLV's signal dropped() to handle drops
	void slotMoved(QListViewItem * item, QListViewItem * afterFirst, QListViewItem * afterNow );
	// slotNewAP()
		// check there is a selected network or AP and add new under it
	// slotNewNetwork()
		// check there is a selection and add new under its parent network
	// slotRemoveItem()
	 	// if the current selection is a network or AP, remove it.
private:
	QListViewItem * m_selectedItem;
	NetworkGroupLVI * m_trustedGroup;
	NetworkGroupLVI * m_untrustedGroup;
	NetworkGroupLVI * m_preferredGroup;
	QValueList< Network * > m_changedNetworks;	
	QValueList< Network * > m_deletedNetworks;	
};

#endif
