/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef NZBFORM_H
#define NZBFORM_H

#include "nzbformdlg.h"
#include <qmap.h>

class BinHeader;
class NewsGroup;

class NzbForm : public NzbFormDlg
{
  Q_OBJECT

  QMap<int, BinHeader*> *headerMap;
  QString destDir;
  
public:
NzbForm(QMap<int, BinHeader*> *hMap, QString dDir, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~NzbForm();
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void          reject();
  virtual void          accept();
  
  void slotSelectionChanged();
  
  void slotMarkAll();
  void slotUnmarkAll();
  void slotMarkSelected();
  void slotUnmarkSelected();
  void slotSelectDir();

	signals:
		void sigDownloadNzbPost(BinHeader*, bool first, QString dir);

};

#endif

