/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kstandarddirs.h>
#include <ktempfile.h>
#include <kmessagebox.h>
#include <qcstring.h>
#include <qfile.h>
#include <kio/job.h>
#include <qdir.h>
#include <kprogress.h>
#include <klocale.h>
#include "kitty_publish.h"
#include "kitty_globals.h"
#include "kitty_feedmodel.h"

kitty_publish::kitty_publish(QWidget *parent, const char *name)
 : QObject(parent, name)
{
	myparent=parent;
}


kitty_publish::~kitty_publish()
{
}

void kitty_publish::publishCancel() {
	copyJob->kill();
	updlg->progressBar()->setValue(100);
	updlg->close();
	KMessageBox::error(myparent,i18n("Publication cancelled."));
}

void kitty_publish::slotresult (KIO::Job *) {
	nextUpload();
}

void kitty_publish::slotpercent (KIO::Job *, unsigned long pc) {
	updlg->progressBar()->setValue(((100*current)+pc)/all);
}

void kitty_publish::nextUpload() {
	if (!uploadQueue.isEmpty()) {
		current++;
		bool over=false;
		QString mydest=dest_upload.url();
		KURL next=uploadQueue.first();
		uploadQueue.remove(uploadQueue.first());
		if (next.url()==tmpfile->name()) { 
			over=true;
			mydest+="feed.xml"; 
		} else {
			mydest+=next.fileName();
		}
		QString qnext=next.url();
		if (next.path().isEmpty()) {
			qnext=QDir::currentDirPath()+"/"+qnext;
		}
		updlg->setLabel(i18n("Uploading %1").arg(next.fileName()));
		copyJob=new KIO::FileCopyJob(qnext,mydest,-1,false,over,false,false);
		connect(copyJob,SIGNAL(percent (KIO::Job *, unsigned long )),this,SLOT(slotpercent (KIO::Job *, unsigned long )));
		connect(copyJob,SIGNAL(result (KIO::Job *)),this,SLOT(slotresult (KIO::Job *)));
	} else {
		updlg->progressBar()->setValue(100);
		updlg->close();
		KMessageBox::information(myparent,i18n("Collection published."));
		tmpfile->unlink();
	}
}

void kitty_publish::publish() {
	// build the xmlfile
	tmpfile =new KTempFile("kittytmp_","_xml");
	uploadQueue.append(tmpfile->name());
	QString xml=buildXML();
	tmpfile->textStream()->writeRawBytes(xml.data(),xml.length());
	tmpfile->close();
	updlg=new KProgressDialog(myparent,"publisher",i18n("Publishing..."),i18n("Uploading..."),true);
	current=-1;
	all=uploadQueue.size();
	connect(updlg,SIGNAL(cancelClicked()),this,SLOT(publishCancel()));
	nextUpload();
	// tmpfile will be removed later
	
}

QString kitty_publish::uploaded_filename(KURL localfilename) {
	KURL remoteurl=destination;
	remoteurl.setFileName(localfilename.fileName());
	return remoteurl.url();
}

QString kitty_publish::articleContentUrl(int id,bool &islocal) {
	if (!feed.items[id].file.isEmpty()) {
		if (feed.items[id].dlstatus=="downloaded" && uploadVideos) {
			islocal=true;
			return locateLocal("appdata", feed.items[id].key);
		} else {
			islocal=false;
			return feed.items[id].file;
		}
	} else {
		islocal=false;
		return "";
	}
}

void kitty_publish::setOutput(KURL upload,KURL site,QString log,QString pas) {
	dest_upload=upload;
	destination=site;
	dest_upload.setUser(log);
	dest_upload.setPass(pas);
}

QString kitty_publish::buildXML() {
	bool islocal;
	QDir *mydir=new QDir();
	QString out;
	QString url;
	out+= "<rss version=\"2.0\">\n";
	out+= "<channel>\n";
	out+= "<title>"+htmlIze(feed.title)+"</title>\n";
	out+= "<description>"+htmlIze(feed.description)+"</description>\n";
	out+= "<author>"+htmlIze(feed.author)+"</author>\n";
	out+= "<generator>Kitty</generator>\n";
	for (int i=0;i<feed.items_count;i++) {
		out+= "<item>\n";
		out+= "<title>"+htmlIze(feed.items[i].title)+"</title>\n";
		out+= "<link>"+htmlIze(feed.items[i].link)+"</link>\n";
		out+= "<description><![CDATA["+htmlIze(feed.items[i].description)+"]]></description>\n";
		out+= "<author>"+htmlIze(feed.items[i].author)+"</author>\n";


		url=feed.items[i].thumbnail;
		if (uploadThumbs) {
			QString imgfile=locateLocal("appdata", feed.key+"-data/"+feed.items[i].key+".png");
			if (mydir->exists(imgfile)) {
				url=uploaded_filename(imgfile);
				uploadQueue.append(imgfile);
			}
		}
		if (!url.isEmpty()) { out+= "<media:thumbnail url=\""+htmlIze(url)+"\"/>\n"; }

		if (!feed.items[i].file.isEmpty()) {
			url=articleContentUrl(i,islocal);
			if (islocal) {
				uploadQueue.append(locateLocal("appdata", feed.key+"-data/"+feed.items[i].key));
				url=uploaded_filename(url);
			}
			out+= "<enclosure url=\""+htmlIze(url)+"\"/>\n";
		}
		out+= "</item>\n";
	}
	out+= "</channel>\n";
	out+= "</rss>\n";
	return out;
}

void kitty_publish::setFeed(t_feed feeddata) {
	feed=feeddata;
}


#include "kitty_publish.moc"
