// ForthCompiler.h
//
// Copyright (c) 1998--2000 Krishna Myneni, Creative Consulting for
//   Research and Education
//
// This software is provided under the terms of the GNU General Public License.
//
// Last Revised: 6-15-2000

#ifndef __FORTHCOMPILER_H__
#define __FORTHCOMPILER_H__

#include <vector>
#include <stack>

#define byte unsigned char
#define NUMBER_OF_INTRINSIC_WORDS 220
#define NUMBER_OF_NON_DEFERRED_WORDS 17
#define NUMBER_OF_IMMEDIATE_WORDS 24
#define PRECEDENCE_IMMEDIATE    1
#define PRECEDENCE_NON_DEFERRED 2
#define TRUE -1
#define FALSE 0
#define MAX_ERR_MESSAGES 12

// Error codes; The corresponding error messages are given in
//   the const char* array C_ErrorMessages, in ForthCompiler.cpp

#define E_C_NOERROR         0
#define E_C_ENDOFSTREAM     1
#define E_C_ENDOFDEF        2
#define E_C_ENDOFSTRING     3
#define E_C_NOTINDEF        4
#define E_C_OPENFILE        5
#define E_C_INCOMPLETEIF    6
#define E_C_INCOMPLETEBEGIN 7
#define E_C_UNKNOWNWORD     8
#define E_C_NODO            9
#define E_C_INCOMPLETELOOP  10
#define E_C_INCOMPLETECASE  11


struct DictionaryEntry
{
  char WordName[32];
  byte Precedence;
  byte WordCode;
  void* Cfa;
  void* Pfa;
};


char* ExtractName (char*, char*);
int IsForthWord (char*, DictionaryEntry*);
int IsFloat (char*, float*);
int IsInt (char*, int*);
int ForthCompiler (vector<byte>*, int*);
void OutputForthByteCode (vector<byte>*);
void SetForthInputStream (istream&);
void SetForthOutputStream (ostream&);

#endif
