\ fsm.4th
\
\ Finite State Machine example in kForth
\
\ Based on the finite state machine examples in 
\ "Finite State Machines in Forth", J. V. Noble, 1995,
\ Journal of Forth Applications and Research.
\
\ Adapted to kForth by K. Myneni, 9-3-2001
\ Requires kForth Rls. 9-3-2001 or later
\
\ Modified 10-22-2001: made defn of WITHIN compatible with ANS, KM
\
\ This code also compiles and runs without change on other 
\ Forth systems (e.g. PFE, GFORTH, ...)  with the definitions:
\
\	: A@ @ ;
\	: ?ALLOT HERE SWAP ALLOT ;
\	: 2+ 2 + ; ( needed for GFORTH)

\ The defining words for creating state machines


: fsm: ( nstates ninputs -- ) 
	create
	  2dup * cells 2*	\ Number of cells for actions and transition 
	  2 cells + ?allot	\ Two more cells to hold the state and width
	  dup >r cell+ ! drop r>  \ Store the width of the table in 2nd cell;
	  2 cells +		\ leave pfa + 2 cells on stack

	does> ( n a -- ) 	\ n is the input condition
	  dup >r 2@ * + 	\ n+width*state
	  2* 2+ cells		\ offset to action
	  r@ +  		\ add offset to address
	  dup >r		\ push for future use	
	  a@ execute 		\ execute the action
	  r> cell+ @ r> !	\ transition to the next state 
;


: { ( addr1 -- addr2 ) ' over ! cell+ ;
: } ( addr2 n -- addr3 ) over ! cell+ ;

: fsm; drop ;

: state< ' >body postpone literal ; immediate	\ Address of state for an fsm 

\ Fixed point number entry example of a finite state machine
\   ( from Noble in J. Forth Appl. and Res.)

: within  ( n m1 m2 -- flag | is m1 <= n < m2 )
	over - >r - r> u< ;

: digit? ( n -- flag ) [char] 0 [char] : within ;

: dp? ( n -- flag ) [char] . = ;

: minus? ( n -- flag ) [char] - = ;

: cat->col# ( c -- n )
	\ Determine the input condition for the entered character
	dup digit? 1 and	\ digit -> 1
	over minus? 2 and +	\ -     -> 2
	swap dp? 3 and +	\ dp    -> 3
;				\ other -> 0


\ Create a finite state machine with 3 states and 4 inputs
\   and define its action table. Each entry in the action table
\   consists of the pair:
\
\ 	{ word_to_be_executed next_state_number }

3 4 fsm: <Fixed.Pt#>
\
\ 			    input:
\
\	  other?	num?	  minus?	dp?	
\ state:
\
  ( 0 )	{ drop 0 }  { emit 1 }  { emit 1 }  { emit 2 }	
  ( 1 )	{ drop 1 }  { emit 1 }  { drop 1 }  { emit 2 }	
  ( 2 )	{ drop 2 }  { emit 2 }  { drop 2 }  { drop 2 }

fsm;

: Getafix ( -- | allow user to enter valid fixed point number )
	0 state< <Fixed.Pt#> !	\ initialize the state to zero
	begin
	  key dup 13 <> over 10 <> and
	while
	  dup cat->col#		\ determine input condition 
	  <Fixed.Pt#>		\ execute the state machine
	repeat 
	drop ;
	
