/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CLASSIMPORT_H
#define CLASSIMPORT_H

#include <qptrlist.h>
#include <qstringlist.h>
#include "umlnamespace.h"
#include "umlattributelist.h"

class UMLDoc;
class UMLObject;
class UMLClass;
class UMLPackage;
class UMLOperation;
class UMLEnum;
class CppDriver;

/**
 * Interfaces classparser library to uml models
 * @author Mikko Pasanen
 * @author Oliver Kellogg
 * Bugs and comments to uml-devel@lists.sf.net or http://bugs.kde.org
 */

class ClassImport {
public:
	ClassImport(UMLDoc *parentDoc);
	~ClassImport();

	/**
	 *
	 */
	void importCPP(QStringList headerFiles);

	/**
	 * Find or create a document object.
	 */
	UMLObject* createUMLObject(Uml::UMLObject_Type type,
				   QString name,
				   QString stereotype = "",
				   QString comment = "",
				   UMLPackage *parentPkg = NULL);

	/**
	 * Create a UMLAttribute and insert it into the document.
	 */
	UMLObject* insertAttribute(UMLClass *klass, Uml::Scope scope, QString name,
				   QString type, QString comment = "",
				   bool isStatic = false);

	/**
	 * Create a UMLOperation.
	 * The reason for this method is to not generate any Qt signals.
	 * Instead, these are generated by insertMethod().
	 * (If we generated a creation signal prematurely, i.e. without
	 * the method parameters being known yet, then that would lead to
	 * a conflict with a pre-existing parameterless method of the same
	 * name.)
	 */
	UMLOperation* makeOperation(UMLClass *parent, QString name);

	/**
	 * Insert the UMLOperation into the document.
	 */
	void insertMethod(UMLClass *klass, UMLOperation *op,
			  Uml::Scope scope, QString type,
			  bool isStatic, bool isAbstract,
			  QString comment = "");

	/**
	 * Add an argument to a UMLOperation.
	 */
	UMLAttribute* addMethodParameter(UMLOperation *method,
					 QString type, QString name,
					 QString initialValue, QString doc,
					 Uml::Parameter_Kind kind = Uml::pk_In);

	/**
	 * Add an enum literal to an UMLEnum.
	 */
	void addEnumLiteral(UMLEnum *enumType, QString literal);

	/**
	 * Create a generalization from the existing child UMLObject to the given
	 * parent class name.
	 */
	void createGeneralization(UMLClass *child, QString parentName);

	/**
	 * Check that a given comment conforms to the Doxygen convention, i.e.
	 * check that it begins with slash-star-star.
	 * Strip the comment lines of leading whitespace and stars.
	 */
	QString doxyComment(QString comment);

private:
	UMLDoc * m_umldoc;  // just a shorthand for UMLApp::app()->getDocument()
	CppDriver * m_driver;
};

#endif
